/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutaredstone.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import withoutaname.mods.withoutaredstone.blocks.WirelessLinkTile;
import withoutaname.mods.withoutaredstone.network.Networking;
import withoutaname.mods.withoutaredstone.network.WirelessLinkModifyPacket;

public class WirelessLinkBlock
extends Block {
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    public static final BooleanProperty RECEIVER = BooleanProperty.func_177716_a((String)"receiver");

    public WirelessLinkBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200947_a(SoundType.field_185848_a).func_200946_b());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0))).func_206870_a((Property)RECEIVER, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull BlockState state, IBlockReader world) {
        return new WirelessLinkTile((Boolean)state.func_177229_b((Property)RECEIVER));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_220069_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        TileEntity te;
        if (!worldIn.field_72995_K && !((Boolean)state.func_177229_b((Property)RECEIVER)).booleanValue() && (te = worldIn.func_175625_s(pos)) instanceof WirelessLinkTile) {
            ((WirelessLinkTile)te).updateSender();
        }
    }

    public void func_225534_a_(@Nonnull BlockState state, @Nonnull ServerWorld worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof WirelessLinkTile) {
            if (((Boolean)state.func_177229_b((Property)RECEIVER)).booleanValue()) {
                ((WirelessLinkTile)te).updateReceiver();
            } else {
                ((WirelessLinkTile)te).updateSender();
            }
        }
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand handIn, @Nonnull BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof WirelessLinkTile) {
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                Networking.sendToClient(new WirelessLinkModifyPacket(serverPlayer, (WirelessLinkTile)te), serverPlayer);
            } else {
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        TileEntity te;
        if (!(newState.func_177230_c() instanceof WirelessLinkBlock) && !worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof WirelessLinkTile) {
            ((WirelessLinkTile)te).blockDestroyed();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWER, RECEIVER});
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public boolean func_149744_f(@Nonnull BlockState state) {
        return state.func_203425_a((Block)this) && (Boolean)state.func_177229_b((Property)RECEIVER) != false;
    }

    public int func_180656_a(@Nonnull BlockState blockState, @Nonnull IBlockReader blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return this.func_149744_f(blockState) ? (Integer)blockState.func_177229_b((Property)POWER) : 0;
    }

    public int func_176211_b(@Nonnull BlockState blockState, @Nonnull IBlockReader blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return this.func_149744_f(blockState) ? (Integer)blockState.func_177229_b((Property)POWER) : 0;
    }
}

