/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutaredstone.blocks;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import withoutaname.mods.withoutaredstone.blocks.WirelessLinkBlock;
import withoutaname.mods.withoutaredstone.data.CapabilityFrequencyPowers;
import withoutaname.mods.withoutaredstone.setup.Registration;

public class WirelessLinkTile
extends TileEntity {
    private long frequency = 0L;
    private boolean receiver = false;

    public WirelessLinkTile() {
        super((TileEntityType)Registration.WIRELESS_LINK_TILE.get());
    }

    public WirelessLinkTile(boolean receiver) {
        this();
        this.receiver = receiver;
        this.func_70296_d();
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            long oldFrequency = this.frequency;
            this.frequency = frequency;
            if (this.receiver) {
                if (this.field_145850_b.func_175667_e(this.field_174879_c)) {
                    this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.removeReceiver(oldFrequency, this));
                    this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.addReceiver(frequency, this));
                    this.updateReceiver();
                }
            } else {
                this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> {
                    HashMap<Long, HashMap<BlockPos, Integer>> frequencyPowers = iFrequencyPowers.getFrequencyPowers();
                    if (frequencyPowers.containsKey(oldFrequency)) {
                        frequencyPowers.get(oldFrequency).remove(this.field_174879_c);
                        iFrequencyPowers.notifyReceivers(oldFrequency);
                    }
                    this.updateSender();
                });
            }
            this.func_70296_d();
        }
    }

    public boolean isReceiver() {
        return this.receiver;
    }

    public void setReceiver(boolean receiver) {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_175667_e(this.field_174879_c)) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)WirelessLinkBlock.RECEIVER, (Comparable)Boolean.valueOf(receiver)));
            this.receiver = receiver;
            if (receiver) {
                this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> {
                    HashMap<Long, HashMap<BlockPos, Integer>> frequencyPowers = iFrequencyPowers.getFrequencyPowers();
                    if (frequencyPowers.containsKey(this.frequency)) {
                        frequencyPowers.get(this.frequency).remove(this.field_174879_c);
                    }
                    iFrequencyPowers.notifyReceivers(this.frequency);
                    iFrequencyPowers.addReceiver(this.frequency, this);
                });
                this.updateReceiver();
            } else {
                this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.removeReceiver(this.frequency, this));
                this.updateSender();
            }
            this.func_70296_d();
        }
    }

    public void updateReceiver() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            AtomicInteger power = new AtomicInteger();
            this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> power.set(iFrequencyPowers.getPower(this.frequency)));
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)WirelessLinkBlock.POWER, (Comparable)Integer.valueOf(power.get())));
        }
    }

    public void updateSender() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.setPower(this.frequency, this.field_174879_c, this.getPower()));
        }
    }

    private int getPower() {
        assert (this.field_145850_b != null);
        int power = this.field_145850_b.func_175687_A(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)WirelessLinkBlock.POWER, (Comparable)Integer.valueOf(power)));
        return power;
    }

    public void onLoad() {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            if (this.receiver) {
                this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.addReceiver(this.frequency, this));
            }
            this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)Registration.WIRELESS_LINK_BLOCK.get(), 0);
        }
    }

    public void onChunkUnloaded() {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.removeReceiver(this.frequency, this));
        }
    }

    public void blockDestroyed() {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            if (this.receiver) {
                this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.removeReceiver(this.frequency, this));
            } else {
                this.field_145850_b.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> {
                    HashMap<Long, HashMap<BlockPos, Integer>> frequencyPowers = iFrequencyPowers.getFrequencyPowers();
                    if (frequencyPowers.containsKey(this.frequency)) {
                        frequencyPowers.get(this.frequency).remove(this.field_174879_c);
                        iFrequencyPowers.notifyReceivers(this.frequency);
                    }
                });
            }
        }
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.frequency = nbt.func_74763_f("frequency");
        this.receiver = nbt.func_74767_n("receiver");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        nbt.func_74772_a("frequency", this.frequency);
        nbt.func_74757_a("receiver", this.receiver);
        return nbt;
    }
}

