/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutaredstone.data;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import withoutaname.mods.withoutaredstone.data.DefaultFrequencyPowers;
import withoutaname.mods.withoutaredstone.data.FrequencyPowersEventHandler;
import withoutaname.mods.withoutaredstone.data.IFrequencyPowers;

public class CapabilityFrequencyPowers {
    @CapabilityInject(value=IFrequencyPowers.class)
    public static Capability<IFrequencyPowers> FREQUENCY_POWERS_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IFrequencyPowers.class, (Capability.IStorage)new Storage(), DefaultFrequencyPowers::new);
        MinecraftForge.EVENT_BUS.addGenericListener(World.class, FrequencyPowersEventHandler::onAttachCapabilitiesEvent);
    }

    private static class Storage
    implements Capability.IStorage<IFrequencyPowers> {
        private Storage() {
        }

        @Nullable
        public INBT writeNBT(Capability<IFrequencyPowers> capability, @Nonnull IFrequencyPowers instance, Direction side) {
            ListNBT frequencyPowersNBT = new ListNBT();
            instance.getFrequencyPowers().forEach((frequency, posPowers) -> {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74772_a("key", frequency.longValue());
                nbt.func_218657_a("value", (INBT)this.getValue((HashMap<BlockPos, Integer>)posPowers));
                frequencyPowersNBT.add((Object)nbt);
            });
            return frequencyPowersNBT;
        }

        @Nonnull
        private ListNBT getValue(@Nonnull HashMap<BlockPos, Integer> posPowers) {
            ListNBT value = new ListNBT();
            posPowers.forEach((pos, power) -> {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("key", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
                nbt.func_74768_a("value", power.intValue());
                value.add((Object)nbt);
            });
            return value;
        }

        public void readNBT(Capability<IFrequencyPowers> capability, IFrequencyPowers instance, Direction side, INBT inbt) {
            HashMap<Long, HashMap<BlockPos, Integer>> frequencyPowers = new HashMap<Long, HashMap<BlockPos, Integer>>();
            if (inbt instanceof ListNBT) {
                for (INBT nbt : (ListNBT)inbt) {
                    if (!(nbt instanceof CompoundNBT)) continue;
                    CompoundNBT compoundNBT = (CompoundNBT)nbt;
                    frequencyPowers.put(compoundNBT.func_74763_f("key"), this.getMap(compoundNBT.func_74781_a("value")));
                }
            }
            instance.setFrequencyPowers(frequencyPowers);
        }

        @Nonnull
        private HashMap<BlockPos, Integer> getMap(INBT inbt) {
            HashMap<BlockPos, Integer> posPowers = new HashMap<BlockPos, Integer>();
            if (inbt instanceof ListNBT) {
                for (INBT nbt : (ListNBT)inbt) {
                    CompoundNBT compoundNBT;
                    INBT posNBT;
                    if (!(nbt instanceof CompoundNBT) || !((posNBT = (compoundNBT = (CompoundNBT)nbt).func_74781_a("key")) instanceof CompoundNBT)) continue;
                    posPowers.put(NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)posNBT)), compoundNBT.func_74762_e("value"));
                }
            }
            return posPowers;
        }
    }
}

