/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutaredstone.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import withoutaname.mods.withoutaredstone.blocks.WirelessLinkTile;
import withoutaname.mods.withoutaredstone.data.IFrequencyPowers;

public class DefaultFrequencyPowers
implements IFrequencyPowers {
    private final HashMap<Long, List<WirelessLinkTile>> receivers = new HashMap();
    private HashMap<Long, HashMap<BlockPos, Integer>> frequencyPowers = new HashMap();

    @Override
    public HashMap<Long, HashMap<BlockPos, Integer>> getFrequencyPowers() {
        return this.frequencyPowers;
    }

    @Override
    public void setFrequencyPowers(HashMap<Long, HashMap<BlockPos, Integer>> frequencyPowers) {
        this.frequencyPowers = frequencyPowers;
    }

    @Override
    public int getPower(long frequency) {
        int power = 0;
        if (this.frequencyPowers.containsKey(frequency)) {
            for (int value : this.frequencyPowers.get(frequency).values()) {
                if (power >= value) continue;
                power = value;
            }
        }
        return power;
    }

    @Override
    public void removePower(long frequency, BlockPos pos) {
        if (this.frequencyPowers.containsKey(frequency)) {
            this.frequencyPowers.get(frequency).remove(pos);
        }
    }

    @Override
    public void setPower(long frequency, BlockPos pos, int power) {
        int oldPower = this.getPower(frequency);
        if (!this.frequencyPowers.containsKey(frequency)) {
            this.frequencyPowers.put(frequency, new HashMap());
        }
        this.frequencyPowers.get(frequency).put(pos, power);
        if (oldPower != power && this.receivers.containsKey(frequency)) {
            this.notifyReceivers(frequency);
        }
    }

    @Override
    public void notifyReceivers(long frequency) {
        if (this.receivers.containsKey(frequency)) {
            for (WirelessLinkTile tile : this.receivers.get(frequency)) {
                tile.updateReceiver();
            }
        }
    }

    @Override
    public void addReceiver(long frequency, WirelessLinkTile tile) {
        List<WirelessLinkTile> wirelessLinkTiles;
        if (!this.receivers.containsKey(frequency)) {
            this.receivers.put(frequency, new ArrayList());
        }
        if (!(wirelessLinkTiles = this.receivers.get(frequency)).contains((Object)tile)) {
            wirelessLinkTiles.add(tile);
        }
    }

    @Override
    public void removeReceiver(long frequency, WirelessLinkTile tile) {
        if (this.receivers.containsKey(frequency)) {
            this.receivers.get(frequency).remove((Object)tile);
        }
    }
}

