/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutaredstone.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import withoutaname.mods.withoutaredstone.network.Networking;
import withoutaname.mods.withoutaredstone.network.WirelessLinkModifyPacket;

public class WirelessLinkModifyScreen
extends Screen {
    protected final ResourceLocation GUI_TEXTURE = new ResourceLocation("withoutaredstone", "textures/gui/wireless_link_modify.png");
    private final int xSize = 228;
    private final int ySize = 68;
    private final Pattern numeric = Pattern.compile("-?\\d+");
    private int guiLeft;
    private int guiTop;
    private long frequency;
    private boolean receiver;
    private Button receiverButton;
    private Button senderButton;
    private TextFieldWidget frequencyTextField;

    public WirelessLinkModifyScreen(long frequency, boolean receiver) {
        super((ITextComponent)new TranslationTextComponent("screen.withoutaredstone.wireless_link_modify"));
        this.frequency = frequency;
        this.receiver = receiver;
    }

    public static void open(long frequency, boolean receiver) {
        Minecraft.func_71410_x().func_147108_a((Screen)new WirelessLinkModifyScreen(frequency, receiver));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - 228) / 2;
        this.guiTop = (this.field_230709_l_ - 68) / 2;
        int i = this.guiLeft + 12;
        int j = this.guiTop + 12;
        this.receiverButton = (Button)this.func_230480_a_((Widget)new Button(i, j, 100, 20, (ITextComponent)new StringTextComponent("Receiver"), button -> this.setReceiver(true)));
        this.senderButton = (Button)this.func_230480_a_((Widget)new Button(i + 104, j, 100, 20, (ITextComponent)new StringTextComponent("Sender"), button -> this.setReceiver(false)));
        this.setReceiver(this.receiver);
        this.frequencyTextField = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230706_i_.field_71466_p, i, j + 24, 204, 20, StringTextComponent.field_240750_d_));
        this.frequencyTextField.func_212954_a(s -> {
            if ("".equals(s) || "-".equals(s)) {
                this.frequency = 0L;
            } else if (this.numeric.matcher((CharSequence)s).matches()) {
                try {
                    this.frequency = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    this.resetFrequencyTextField();
                }
            } else {
                this.resetFrequencyTextField();
            }
        });
        this.resetFrequencyTextField();
    }

    private void resetFrequencyTextField() {
        this.frequencyTextField.func_146180_a(String.valueOf(this.frequency));
    }

    private void setReceiver(boolean receiver) {
        this.receiver = receiver;
        this.receiverButton.field_230693_o_ = !receiver;
        this.senderButton.field_230693_o_ = receiver;
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.drawGuiBackgroundLayer(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void drawGuiBackgroundLayer(MatrixStack matrixStack) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(this.GUI_TEXTURE);
        int i = this.guiLeft;
        int j = this.guiTop;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.xSize, this.ySize);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231164_f_() {
        Networking.sendToServer(new WirelessLinkModifyPacket(this.frequency, this.receiver));
    }
}

