/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutaredstone.blocks;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import withoutaname.mods.withoutaredstone.blocks.WirelessLinkBlock;
import withoutaname.mods.withoutaredstone.data.CapabilityFrequencyPowers;
import withoutaname.mods.withoutaredstone.setup.Registration;

public class WirelessLinkEntity
extends BlockEntity {
    private long frequency = 0L;
    private boolean receiver = false;

    public WirelessLinkEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.WIRELESS_LINK_TILE.get(), pos, state);
        this.receiver = (Boolean)state.m_61143_((Property)WirelessLinkBlock.RECEIVER);
        this.m_6596_();
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            long oldFrequency = this.frequency;
            this.frequency = frequency;
            if (this.receiver) {
                if (this.f_58857_.m_46805_(this.f_58858_)) {
                    this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.removeReceiver(oldFrequency, this));
                    this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.addReceiver(frequency, this));
                    this.updateReceiver();
                }
            } else {
                this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> {
                    HashMap<Long, HashMap<BlockPos, Integer>> frequencyPowers = iFrequencyPowers.getFrequencyPowers();
                    if (frequencyPowers.containsKey(oldFrequency)) {
                        frequencyPowers.get(oldFrequency).remove(this.f_58858_);
                        iFrequencyPowers.notifyReceivers(oldFrequency);
                    }
                    this.updateSender();
                });
            }
            this.m_6596_();
        }
    }

    public boolean isReceiver() {
        return this.receiver;
    }

    public void setReceiver(boolean receiver) {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46805_(this.f_58858_)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)WirelessLinkBlock.RECEIVER, (Comparable)Boolean.valueOf(receiver)));
            this.receiver = receiver;
            if (receiver) {
                this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> {
                    HashMap<Long, HashMap<BlockPos, Integer>> frequencyPowers = iFrequencyPowers.getFrequencyPowers();
                    if (frequencyPowers.containsKey(this.frequency)) {
                        frequencyPowers.get(this.frequency).remove(this.f_58858_);
                    }
                    iFrequencyPowers.notifyReceivers(this.frequency);
                    iFrequencyPowers.addReceiver(this.frequency, this);
                });
                this.updateReceiver();
            } else {
                this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.removeReceiver(this.frequency, this));
                this.updateSender();
            }
            this.m_6596_();
        }
    }

    public void updateReceiver() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            AtomicInteger power = new AtomicInteger();
            this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> power.set(iFrequencyPowers.getPower(this.frequency)));
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)WirelessLinkBlock.POWER, (Comparable)Integer.valueOf(power.get())));
        }
    }

    public void updateSender() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.setPower(this.frequency, this.f_58858_, this.getPower()));
        }
    }

    private int getPower() {
        assert (this.f_58857_ != null);
        int power = this.f_58857_.m_46755_(this.f_58858_);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)WirelessLinkBlock.POWER, (Comparable)Integer.valueOf(power)));
        return power;
    }

    public void m_6339_() {
        super.m_6339_();
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            if (this.receiver) {
                this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.addReceiver(this.frequency, this));
            }
            this.f_58857_.m_6219_().m_5945_(this.f_58858_, (Object)((Block)Registration.WIRELESS_LINK_BLOCK.get()), 0);
        }
    }

    public void m_7651_() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.removeReceiver(this.frequency, this));
        }
        super.m_7651_();
    }

    public void blockDestroyed() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            if (this.receiver) {
                this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> iFrequencyPowers.removeReceiver(this.frequency, this));
            } else {
                this.f_58857_.getCapability(CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY).ifPresent(iFrequencyPowers -> {
                    HashMap<Long, HashMap<BlockPos, Integer>> frequencyPowers = iFrequencyPowers.getFrequencyPowers();
                    if (frequencyPowers.containsKey(this.frequency)) {
                        frequencyPowers.get(this.frequency).remove(this.f_58858_);
                        iFrequencyPowers.notifyReceivers(this.frequency);
                    }
                });
            }
        }
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.frequency = tag.m_128454_("frequency");
        this.receiver = tag.m_128471_("receiver");
    }

    @Nonnull
    public CompoundTag m_6945_(@Nonnull CompoundTag compound) {
        CompoundTag tag = super.m_6945_(compound);
        tag.m_128356_("frequency", this.frequency);
        tag.m_128379_("receiver", this.receiver);
        return tag;
    }
}

