/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutaredstone.data;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import withoutaname.mods.withoutaredstone.data.CapabilityFrequencyPowers;
import withoutaname.mods.withoutaredstone.data.DefaultFrequencyPowers;
import withoutaname.mods.withoutaredstone.data.IFrequencyPowers;

public class FrequencyPowersProvider
implements ICapabilitySerializable<Tag> {
    private final DefaultFrequencyPowers frequencyPowers = new DefaultFrequencyPowers();
    private final LazyOptional<IFrequencyPowers> frequencyPowersOptional = LazyOptional.of(() -> this.frequencyPowers);

    public void invalidate() {
        this.frequencyPowersOptional.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFrequencyPowers.FREQUENCY_POWERS_CAPABILITY) {
            return this.frequencyPowersOptional.cast();
        }
        return LazyOptional.empty();
    }

    public Tag serializeNBT() {
        ListTag frequencyPowersNBT = new ListTag();
        this.frequencyPowers.getFrequencyPowers().forEach((frequency, posPowers) -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("key", frequency.longValue());
            nbt.m_128365_("value", (Tag)this.getValue((HashMap<BlockPos, Integer>)posPowers));
            frequencyPowersNBT.add((Object)nbt);
        });
        return frequencyPowersNBT;
    }

    @Nonnull
    private ListTag getValue(@Nonnull HashMap<BlockPos, Integer> posPowers) {
        ListTag value = new ListTag();
        posPowers.forEach((pos, power) -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("key", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            nbt.m_128405_("value", power.intValue());
            value.add((Object)nbt);
        });
        return value;
    }

    public void deserializeNBT(Tag tag) {
        HashMap<Long, HashMap<BlockPos, Integer>> frequencyPowers = new HashMap<Long, HashMap<BlockPos, Integer>>();
        if (tag instanceof ListTag) {
            for (Tag nbt : (ListTag)tag) {
                Tag tag2 = nbt;
                if (!(tag2 instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)tag2;
                frequencyPowers.put(compoundTag.m_128454_("key"), this.getMap(compoundTag.m_128423_("value")));
            }
        }
        this.frequencyPowers.setFrequencyPowers(frequencyPowers);
    }

    @Nonnull
    private HashMap<BlockPos, Integer> getMap(Tag tag) {
        HashMap<BlockPos, Integer> posPowers = new HashMap<BlockPos, Integer>();
        if (tag instanceof ListTag) {
            for (Tag nbt : (ListTag)tag) {
                CompoundTag compoundTag;
                Tag posNBT;
                Tag tag2 = nbt;
                if (!(tag2 instanceof CompoundTag) || !((posNBT = (compoundTag = (CompoundTag)tag2).m_128423_("key")) instanceof CompoundTag)) continue;
                posPowers.put(NbtUtils.m_129239_((CompoundTag)((CompoundTag)posNBT)), compoundTag.m_128451_("value"));
            }
        }
        return posPowers;
    }
}

