/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutaredstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import withoutaname.mods.withoutaredstone.network.Networking;
import withoutaname.mods.withoutaredstone.network.WirelessLinkModifyPacket;

public class WirelessLinkModifyScreen
extends Screen {
    protected final ResourceLocation GUI_TEXTURE = new ResourceLocation("withoutaredstone", "textures/gui/wireless_link_modify.png");
    private final int xSize = 228;
    private final int ySize = 68;
    private final Pattern numeric = Pattern.compile("-?\\d+");
    private int guiLeft;
    private int guiTop;
    private long frequency;
    private boolean receiver;
    private Button receiverButton;
    private Button senderButton;
    private EditBox frequencyTextField;

    public WirelessLinkModifyScreen(long frequency, boolean receiver) {
        super((Component)new TranslatableComponent("screen.withoutaredstone.wireless_link_modify"));
        this.frequency = frequency;
        this.receiver = receiver;
    }

    public static void open(long frequency, boolean receiver) {
        Minecraft.m_91087_().m_91152_((Screen)new WirelessLinkModifyScreen(frequency, receiver));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 228) / 2;
        this.guiTop = (this.f_96544_ - 68) / 2;
        int i = this.guiLeft + 12;
        int j = this.guiTop + 12;
        this.receiverButton = (Button)this.m_142416_((GuiEventListener)new Button(i, j, 100, 20, (Component)new TextComponent("Receiver"), button -> this.setReceiver(true)));
        this.senderButton = (Button)this.m_142416_((GuiEventListener)new Button(i + 104, j, 100, 20, (Component)new TextComponent("Sender"), button -> this.setReceiver(false)));
        this.setReceiver(this.receiver);
        this.frequencyTextField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96541_.f_91062_, i, j + 24, 204, 20, TextComponent.f_131282_));
        this.frequencyTextField.m_94151_(s -> {
            if ("".equals(s) || "-".equals(s)) {
                this.frequency = 0L;
            } else if (this.numeric.matcher((CharSequence)s).matches()) {
                try {
                    this.frequency = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    this.resetFrequencyTextField();
                }
            } else {
                this.resetFrequencyTextField();
            }
        });
        this.resetFrequencyTextField();
    }

    private void resetFrequencyTextField() {
        this.frequencyTextField.m_94144_(String.valueOf(this.frequency));
    }

    private void setReceiver(boolean receiver) {
        this.receiver = receiver;
        this.receiverButton.f_93623_ = !receiver;
        this.senderButton.f_93623_ = receiver;
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        this.drawGuiBackgroundLayer(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    protected void drawGuiBackgroundLayer(PoseStack poseStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI_TEXTURE);
        int i = this.guiLeft;
        int j = this.guiTop;
        this.m_93228_(poseStack, i, j, 0, 0, this.xSize, this.ySize);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        Networking.sendToServer(new WirelessLinkModifyPacket(this.frequency, this.receiver));
    }
}

