/*
 * Decompiled with CFR 0.152.
 */
package com.zimonishim.ziheasymodding.modItems.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.zimonishim.ziheasymodding.modItems.item.ZIHTieredItem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.world.IBlockReader;

public class ZIHToolItem
extends ZIHTieredItem {
    private Set<Block> effectiveBlocks;
    protected float efficiency;
    private float attackDamage;
    private Multimap<Attribute, AttributeModifier> toolAttributes;

    public ZIHToolItem(float attackDamage, float attackSpeed, IItemTier tier, Item.Properties properties) {
        this(attackDamage, attackSpeed, tier, new HashSet<Block>(), properties);
    }

    public ZIHToolItem(float attackDamageIn, float attackSpeedIn, IItemTier tier, Set<Block> effectiveBlocksIn, Item.Properties properties) {
        super(tier, properties);
        this.effectiveBlocks = effectiveBlocksIn;
        this.efficiency = tier.func_200928_b();
        this.attackDamage = attackDamageIn + tier.func_200929_c();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.toolAttributes = builder.build();
        this.setGetDestroySpeed((stack, state) -> {
            if (this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0))) {
                return this.efficiency;
            }
            return this.effectiveBlocks.contains(state.func_177230_c()) ? this.efficiency : 1.0f;
        });
        this.setHitEntity((stack, target, attacker) -> {
            stack.func_222118_a(2, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
            return true;
        });
        this.setOnBlockDestroyed((stack, worldIn, state, pos, entityLiving) -> {
            if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
                stack.func_222118_a(1, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
            }
            return true;
        });
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.MAINHAND ? this.toolAttributes : super.func_111205_h(slot);
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }
}

