/*
 * Decompiled with CFR 0.152.
 */
package com.zimonishim.ziheasymodding.modMaterial;

import com.zimonishim.ziheasymodding.creators.ZIHArmorCreator;
import com.zimonishim.ziheasymodding.creators.ZIHToolsCreator;
import com.zimonishim.ziheasymodding.modInit.callbacks.IItemCallback;
import com.zimonishim.ziheasymodding.modItems.item.ZIHArmorItem;
import com.zimonishim.ziheasymodding.modItems.item.ZIHAxeItem;
import com.zimonishim.ziheasymodding.modItems.item.ZIHHoeItem;
import com.zimonishim.ziheasymodding.modItems.item.ZIHPickaxeItem;
import com.zimonishim.ziheasymodding.modItems.item.ZIHShovelItem;
import com.zimonishim.ziheasymodding.modItems.item.ZIHSwordItem;
import com.zimonishim.ziheasymodding.modMaterial.ZIHMaterial;
import com.zimonishim.ziheasymodding.util.StringHandler;

public class ZIHMaterialItems {
    private ZIHPickaxeItem pickaxeItem;
    private ZIHAxeItem axeItem;
    private ZIHShovelItem shovelItem;
    private ZIHHoeItem hoeItem;
    private ZIHSwordItem swordItem;
    private ZIHArmorItem helmetItem;
    private ZIHArmorItem chestplateItem;
    private ZIHArmorItem legsItem;
    private ZIHArmorItem bootsItem;
    private final String materialName;
    private ZIHToolsCreator zihToolsCreator;
    private ZIHArmorCreator zihArmorCreator;

    public ZIHMaterialItems(ZIHMaterial zihMaterial) {
        this.materialName = zihMaterial.getMaterialName();
        this.zihToolsCreator = new ZIHToolsCreator(zihMaterial.getItemTier());
        this.zihArmorCreator = new ZIHArmorCreator(zihMaterial.getArmorMaterial());
        this.pickaxeItem = this.zihToolsCreator.createPickaxeItem();
        this.axeItem = this.zihToolsCreator.createAxeItem();
        this.shovelItem = this.zihToolsCreator.createShovelItem();
        this.hoeItem = this.zihToolsCreator.createHoeItem();
        this.swordItem = this.zihToolsCreator.createSwordItem();
        this.helmetItem = this.zihArmorCreator.createHelmet();
        this.chestplateItem = this.zihArmorCreator.createChestplate();
        this.legsItem = this.zihArmorCreator.createLeggings();
        this.bootsItem = this.zihArmorCreator.createShoes();
    }

    public void registerAll(IItemCallback callback) {
        this.registerAllTools(callback);
        this.registerAllArmorItems(callback);
    }

    public void registerAllTools(IItemCallback callback) {
        this.pickaxeItem.register(StringHandler.getPickaxeString(this.materialName), callback);
        this.axeItem.register(StringHandler.getAxeString(this.materialName), callback);
        this.shovelItem.register(StringHandler.getShovelString(this.materialName), callback);
        this.hoeItem.register(StringHandler.getHoeString(this.materialName), callback);
        this.swordItem.register(StringHandler.getSwordString(this.materialName), callback);
    }

    public void registerAllArmorItems(IItemCallback callback) {
        this.helmetItem.register(StringHandler.getHelmetString(this.materialName), callback);
        this.chestplateItem.register(StringHandler.getChestplateString(this.materialName), callback);
        this.legsItem.register(StringHandler.getLegsString(this.materialName), callback);
        this.bootsItem.register(StringHandler.getBootsString(this.materialName), callback);
    }

    public ZIHPickaxeItem getPickaxeItem() {
        return this.pickaxeItem;
    }

    public void setPickaxeItem(ZIHPickaxeItem pickaxeItem) {
        this.pickaxeItem = pickaxeItem;
    }

    public ZIHAxeItem getAxeItem() {
        return this.axeItem;
    }

    public void setAxeItem(ZIHAxeItem axeItem) {
        this.axeItem = axeItem;
    }

    public ZIHShovelItem getShovelItem() {
        return this.shovelItem;
    }

    public void setShovelItem(ZIHShovelItem shovelItem) {
        this.shovelItem = shovelItem;
    }

    public ZIHHoeItem getHoeItem() {
        return this.hoeItem;
    }

    public void setHoeItem(ZIHHoeItem hoeItem) {
        this.hoeItem = hoeItem;
    }

    public ZIHSwordItem getSwordItem() {
        return this.swordItem;
    }

    public void setSwordItem(ZIHSwordItem swordItem) {
        this.swordItem = swordItem;
    }

    public ZIHArmorItem getHelmetItem() {
        return this.helmetItem;
    }

    public void setHelmetItem(ZIHArmorItem helmetItem) {
        this.helmetItem = helmetItem;
    }

    public ZIHArmorItem getChestplateItem() {
        return this.chestplateItem;
    }

    public void setChestplateItem(ZIHArmorItem chestplateItem) {
        this.chestplateItem = chestplateItem;
    }

    public ZIHArmorItem getLegsItem() {
        return this.legsItem;
    }

    public void setLegsItem(ZIHArmorItem legsItem) {
        this.legsItem = legsItem;
    }

    public ZIHArmorItem getBootsItem() {
        return this.bootsItem;
    }

    public void setBootsItem(ZIHArmorItem bootsItem) {
        this.bootsItem = bootsItem;
    }

    public ZIHToolsCreator getZihTools() {
        return this.zihToolsCreator;
    }

    public void setZihTools(ZIHToolsCreator zihToolsCreator) {
        this.zihToolsCreator = zihToolsCreator;
    }

    public ZIHArmorCreator getZihArmor() {
        return this.zihArmorCreator;
    }

    public void setZihArmor(ZIHArmorCreator zihArmorCreator) {
        this.zihArmorCreator = zihArmorCreator;
    }

    public String getMaterialName() {
        return this.materialName;
    }
}

