/*
 * Decompiled with CFR 0.152.
 */
package com.zimonishim.ziheasymodding.modItems.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.zimonishim.ziheasymodding.modItems.item.ZIHTieredItem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;

public class ZIHDiggerItem
extends ZIHTieredItem
implements Vanishable {
    private Tag<Block> effectiveBlocks;
    protected float efficiency;
    private float attackDamage;
    private Multimap<Attribute, AttributeModifier> toolAttributes;

    public ZIHDiggerItem(float attackDamage, float attackSpeed, Tier tier, Item.Properties properties) {
        this(attackDamage, attackSpeed, tier, new HashSet<Block>(), properties);
    }

    public ZIHDiggerItem(float attackDamageIn, float attackSpeedIn, Tier tier, Set<Block> effectiveBlocksIn, Item.Properties properties) {
        this(attackDamageIn, attackSpeedIn, tier, (Tag<Block>)Tag.m_13300_(effectiveBlocksIn), properties);
    }

    public ZIHDiggerItem(float attackDamageIn, float attackSpeedIn, Tier tier, Tag<Block> effectiveBlocksIn, Item.Properties properties) {
        super(tier, properties);
        this.effectiveBlocks = effectiveBlocksIn;
        this.efficiency = tier.m_6624_();
        this.attackDamage = attackDamageIn + tier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.toolAttributes = builder.build();
        this.setGetDestroySpeed((stack, state) -> this.effectiveBlocks.m_8110_((Object)state.m_60734_()) ? this.efficiency : 1.0f);
        this.setHitEntity((stack, target, attacker) -> {
            stack.m_41622_(2, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            return true;
        });
        this.setOnBlockDestroyed((stack, worldIn, state, pos, entityLiving) -> {
            if (!worldIn.f_46443_ && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
                stack.m_41622_(1, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            }
            return true;
        });
    }

    @Override
    @Deprecated
    public boolean m_8096_(BlockState p_150816_) {
        if (TierSortingRegistry.isTierSorted((Tier)this.getTier())) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.getTier(), (BlockState)p_150816_) && p_150816_.m_60620_(this.effectiveBlocks);
        }
        int i = this.getTier().m_6604_();
        if (i < 3 && p_150816_.m_60620_((Tag)BlockTags.f_144284_)) {
            return false;
        }
        if (i < 2 && p_150816_.m_60620_((Tag)BlockTags.f_144285_)) {
            return false;
        }
        return i < 1 && p_150816_.m_60620_((Tag)BlockTags.f_144286_) ? false : p_150816_.m_60620_(this.effectiveBlocks);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_60620_(this.effectiveBlocks) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.getTier(), (BlockState)state);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.toolAttributes : super.m_7167_(slot);
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }
}

