/*
 * Decompiled with CFR 0.152.
 */
package com.zimonishim.ziheasymodding.modItems.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.zimonishim.ziheasymodding.modItems.item.ZIHTieredItem;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ZIHSwordItem
extends ZIHTieredItem
implements Vanishable {
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public ZIHSwordItem(int attackDamage, float attackSpeed, Tier tier, Item.Properties properties) {
        super(tier, properties);
        this.attackDamage = (float)attackDamage + tier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
        this.setCanPlayerBreakBlockWhileHolding((state, worldIn, pos, player) -> !player.m_7500_());
        this.setGetDestroySpeed((stack, state) -> {
            if (state.m_60713_(Blocks.f_50033_)) {
                return 15.0f;
            }
            Material material = state.m_60767_();
            return material != Material.f_76300_ && material != Material.f_76302_ && !state.m_60620_((Tag)BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
        });
        this.setHitEntity((stack, target, attacker) -> {
            stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            return true;
        });
        this.setOnBlockDestroyed((stack, worldIn, state, pos, entityLiving) -> {
            if (state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
                stack.m_41622_(2, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            }
            return true;
        });
        this.setCanHarvestBlock(blockIn -> blockIn.m_60713_(Blocks.f_50033_));
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(slot);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }
}

