/*
 * Decompiled with CFR 0.152.
 */
package com.madalchemist.zombienation;

import com.madalchemist.zombienation.BiomeDictionaryHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final Spawn SPAWN = new Spawn(BUILDER);
    public static Infection INFECTION = new Infection(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class Spawn {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> include;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> exclude;
        public final ForgeConfigSpec.IntValue spawnWeightNormal;
        public final ForgeConfigSpec.IntValue minGroupNormal;
        public final ForgeConfigSpec.IntValue maxGroupNormal;
        public final ForgeConfigSpec.IntValue spawnWeightTough;
        public final ForgeConfigSpec.IntValue minGroupTough;
        public final ForgeConfigSpec.IntValue maxGroupTough;
        public final ForgeConfigSpec.IntValue spawnWeightFrozenLumberjack;
        public final ForgeConfigSpec.IntValue minGroupFrozenLumberjack;
        public final ForgeConfigSpec.IntValue maxGroupFrozenLumberjack;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> frozenLumberjackBiomes;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bearBiomes;
        public final ForgeConfigSpec.IntValue spawnWeightBrownBear;
        public final ForgeConfigSpec.IntValue minGroupBrownBear;
        public final ForgeConfigSpec.IntValue maxGroupBrownBear;
        public final ForgeConfigSpec.IntValue spawnWeightZombieBear;
        public final ForgeConfigSpec.IntValue minGroupZombieBear;
        public final ForgeConfigSpec.IntValue maxGroupZombieBear;

        Spawn(ForgeConfigSpec.Builder builder) {
            builder.push("Spawn");
            this.include = builder.comment("BiomeDictionary types to include").defineList("include", Collections.singletonList(BiomeDictionary.Type.OVERWORLD.toString()), o -> BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(String.valueOf(o))));
            this.exclude = builder.comment("BiomeDictionary types to exclude (overrides \"include\")").defineList("exclude", Arrays.asList(BiomeDictionary.Type.NETHER.toString(), BiomeDictionary.Type.END.toString()), o -> BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(String.valueOf(o))));
            this.spawnWeightNormal = builder.comment("Normal zombie spawn weight (0-1000, vanilla zombies == 100").defineInRange("spawnWeightNormal", 100, 0, 1000);
            this.minGroupNormal = builder.comment("Normal zombie min count in group (0-16, vanilla zombies == 2)").defineInRange("minGroupNormal", 2, 0, 16);
            this.maxGroupNormal = builder.comment("Normal zombie max count in group (0-16, vanilla zombies == 4)").defineInRange("maxGroupNormal", 4, 0, 16);
            this.spawnWeightTough = builder.comment("Tough zombie (warriors, miners) spawn weight (0-1000, vanilla zombies == 100").defineInRange("spawnWeightTough", 10, 0, 1000);
            this.minGroupTough = builder.comment("Tough zombie (warriors, miners) min count in group (0-16, vanilla zombies == 2)").defineInRange("minGroupTough", 1, 0, 16);
            this.maxGroupTough = builder.comment("Tough zombie (warriors, miners) max count in group (0-16, vanilla zombies == 4)").defineInRange("maxGroupTough", 2, 0, 16);
            this.frozenLumberjackBiomes = builder.comment("Biomes where frozen lumberjacks will spawn:").defineList("frozenLumberjackBiomes", Collections.singletonList(BiomeDictionary.Type.SNOWY.toString()), o -> BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(String.valueOf(o))));
            this.spawnWeightFrozenLumberjack = builder.comment("Frozen lumberjack spawn weight, 0-1000, vanilla zombies == 100").defineInRange("spawnWeightFrozenLumberjack", 100, 0, 1000);
            this.minGroupFrozenLumberjack = builder.comment("Frozen lumberjacks min count in group, 0-16, vanilla zombies == 2").defineInRange("minGroupFrozenLumberjacks", 2, 0, 16);
            this.maxGroupFrozenLumberjack = builder.comment("Frozen lumberjacks max count in group, 0-16, vanilla zombies == 4").defineInRange("maxGroupFrozenLumberjacks", 4, 0, 16);
            this.bearBiomes = builder.comment("Biomes where brown bears and zombie bears will spawn:").defineList("bearBiomes", Collections.singletonList(BiomeDictionary.Type.FOREST.toString()), o -> BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(String.valueOf(o))));
            this.spawnWeightBrownBear = builder.comment("Brown bear spawn weight:").defineInRange("spawnWeightBrownBear", 10, 0, 1000);
            this.minGroupBrownBear = builder.comment("Brown bear min count in group, 0-16:").defineInRange("minGroupBrownBear", 1, 0, 16);
            this.maxGroupBrownBear = builder.comment("Brown bear max count in group, 0-16:").defineInRange("maxGroupBrownBear", 3, 0, 16);
            this.spawnWeightZombieBear = builder.comment("Zombie bear spawn weight:").defineInRange("spawnWeightZombieBear", 10, 0, 1000);
            this.minGroupZombieBear = builder.comment("Zombie bear min count in group, 0-16:").defineInRange("minGroupZombieBear", 1, 0, 16);
            this.maxGroupZombieBear = builder.comment("Zombie bear max count in group, 0-16:").defineInRange("maxGroupZombieBear", 3, 0, 16);
            builder.pop();
        }
    }

    public static class Infection {
        public final ForgeConfigSpec.DoubleValue infectionChance;
        public final ForgeConfigSpec.IntValue infectionDuration;
        public final ForgeConfigSpec.BooleanValue infectionHunger;
        public final ForgeConfigSpec.BooleanValue infectionNausea;
        public final ForgeConfigSpec.BooleanValue infectionWeakness;
        public final ForgeConfigSpec.BooleanValue infectionDeathZombification;
        public final ForgeConfigSpec.BooleanValue hardcoreInfection;

        Infection(ForgeConfigSpec.Builder builder) {
            builder.push("Infection");
            this.infectionChance = builder.comment("Infection chance from being hit by zombie, min: 0.0, max: 1.0, default: 0.1").defineInRange("infectionChance", 0.1, 0.0, 1.0);
            this.infectionDuration = builder.comment("Infection duration in seconds before you die:").defineInRange("infectionDuration", 3600, 0, Integer.MAX_VALUE);
            this.infectionHunger = builder.comment("Does infection cause hunger?").define("infectionHunger", true);
            this.infectionNausea = builder.comment("Does infection cause nausea?").define("infectionNausea", true);
            this.infectionWeakness = builder.comment("Does infection cause weakness?").define("infectionWeakness", true);
            this.infectionDeathZombification = builder.comment("Spawn vanilla zombie when player dies from infection?").define("infectionDeathZombification", true);
            this.hardcoreInfection = builder.comment("Enable hardcore infection (disables cure for players, infected = dead)?").define("hardcoreInfection", false);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.BooleanValue burnAtDay;
        public final ForgeConfigSpec.BooleanValue warriorsHaveSwords;
        public final ForgeConfigSpec.BooleanValue minersHavePickaxes;
        public final ForgeConfigSpec.BooleanValue hazmatSuitProtectsFromPotions;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.burnAtDay = builder.comment("Do modded zombies burn at day (not affects vanilla zombies)?").define("burnAtDay", false);
            this.warriorsHaveSwords = builder.comment("Do zombie warriors have enchanted iron swords?").define("warriorsHaveSwords", true);
            this.minersHavePickaxes = builder.comment("Do zombie miners have iron pickaxes?").define("minersHavePickaxes", true);
            this.hazmatSuitProtectsFromPotions = builder.comment("Are hazmat zombies immune to potions?").define("hazmatSuitProtectsFromPotions", true);
            builder.pop();
        }
    }
}

