/*
 * Decompiled with CFR 0.152.
 */
package com.madalchemist.zombienation;

import com.madalchemist.zombienation.BiomeDictionaryHelper;
import com.madalchemist.zombienation.ConfigHandler;
import com.madalchemist.zombienation.ZombiesRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="zombienation")
public class ZombieSpawn {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addSpawn(BiomeLoadingEvent event) {
        Biome biome;
        if (event.getName() != null && (biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName())) != null) {
            RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
            List<BiomeDictionary.Type> includeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray((List)ConfigHandler.SPAWN.include.get()));
            List<BiomeDictionary.Type> excludeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray((List)ConfigHandler.SPAWN.exclude.get()));
            List<BiomeDictionary.Type> lumberjackList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray((List)ConfigHandler.SPAWN.frozenLumberjackBiomes.get()));
            List<BiomeDictionary.Type> bearList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray((List)ConfigHandler.SPAWN.bearBiomes.get()));
            if (!includeList.isEmpty()) {
                Set biomeTypes = BiomeDictionary.getTypes((RegistryKey)biomeKey);
                if (biomeTypes.stream().noneMatch(excludeList::contains)) {
                    if (biomeTypes.stream().anyMatch(includeList::contains)) {
                        int spawnWeightNormal = (Integer)ConfigHandler.SPAWN.spawnWeightNormal.get();
                        int minGroupNormal = (Integer)ConfigHandler.SPAWN.minGroupNormal.get();
                        int maxGroupNormal = (Integer)ConfigHandler.SPAWN.maxGroupNormal.get();
                        int spawnWeightTough = (Integer)ConfigHandler.SPAWN.spawnWeightTough.get();
                        int minGroupTough = (Integer)ConfigHandler.SPAWN.minGroupTough.get();
                        int maxGroupTough = (Integer)ConfigHandler.SPAWN.maxGroupTough.get();
                        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.ZOMBIE_1.get(), spawnWeightNormal, minGroupNormal, maxGroupNormal));
                        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.ZOMBIE_2.get(), spawnWeightNormal, minGroupNormal, maxGroupNormal));
                        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.ZOMBIE_3.get(), spawnWeightTough, minGroupTough, maxGroupTough));
                        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.ZOMBIE_4.get(), spawnWeightTough, minGroupTough, maxGroupTough));
                        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.ZOMBIE_5.get(), spawnWeightNormal, minGroupNormal, maxGroupNormal));
                        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.ZOMBIE_6.get(), spawnWeightNormal, minGroupNormal, maxGroupNormal));
                        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.ZOMBIE_7.get(), spawnWeightNormal, minGroupNormal, maxGroupNormal));
                        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.ZOMBIE_8.get(), spawnWeightNormal, minGroupNormal, maxGroupNormal));
                        if (biomeTypes.stream().anyMatch(lumberjackList::contains)) {
                            int spawnWeightLumberjack = (Integer)ConfigHandler.SPAWN.spawnWeightFrozenLumberjack.get();
                            int groupMinLumberjack = (Integer)ConfigHandler.SPAWN.minGroupFrozenLumberjack.get();
                            int groupMaxLumberjack = (Integer)ConfigHandler.SPAWN.maxGroupFrozenLumberjack.get();
                            event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.ZOMBIE_9.get(), spawnWeightLumberjack, groupMinLumberjack, groupMaxLumberjack));
                        }
                        if (biomeTypes.stream().anyMatch(bearList::contains)) {
                            int spawnWeightBrownBear = (Integer)ConfigHandler.SPAWN.spawnWeightBrownBear.get();
                            int groupMinBrownBear = (Integer)ConfigHandler.SPAWN.minGroupBrownBear.get();
                            int groupMaxBrownBear = (Integer)ConfigHandler.SPAWN.maxGroupBrownBear.get();
                            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.BROWN_BEAR.get(), spawnWeightBrownBear, groupMinBrownBear, groupMaxBrownBear));
                        }
                        if (biomeTypes.stream().anyMatch(bearList::contains)) {
                            int spawnWeightZombieBear = (Integer)ConfigHandler.SPAWN.spawnWeightZombieBear.get();
                            int groupMinZombieBear = (Integer)ConfigHandler.SPAWN.minGroupZombieBear.get();
                            int groupMaxZombieBear = (Integer)ConfigHandler.SPAWN.maxGroupZombieBear.get();
                            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)ZombiesRegistry.ZOMBIE_BEAR.get(), spawnWeightZombieBear, groupMinZombieBear, groupMaxZombieBear));
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("Do not leave the BiomeDictionary \"include\" or \"frozenLumberjackBiomes\" lists empty. If you wish to disable spawning of an entity, set the weight to 0 instead.");
            }
        }
    }
}

