/*
 * Decompiled with CFR 0.152.
 */
package com.madalchemist.zombienation;

import com.madalchemist.zombienation.ConfigHandler;
import com.madalchemist.zombienation.CreativeTab;
import com.madalchemist.zombienation.ModItems;
import com.madalchemist.zombienation.Registrator;
import com.madalchemist.zombienation.ZombiesRegistry;
import com.madalchemist.zombienation.animals.BrownBearRenderer;
import com.madalchemist.zombienation.potions.AntizombineRecipe;
import com.madalchemist.zombienation.potions.PotionZombieVirus;
import com.madalchemist.zombienation.zombies.ZombieBearRenderer;
import com.madalchemist.zombienation.zombies.Zombie_1_Renderer;
import com.madalchemist.zombienation.zombies.Zombie_2_Renderer;
import com.madalchemist.zombienation.zombies.Zombie_3_Renderer;
import com.madalchemist.zombienation.zombies.Zombie_4_Renderer;
import com.madalchemist.zombienation.zombies.Zombie_5_Renderer;
import com.madalchemist.zombienation.zombies.Zombie_6_Renderer;
import com.madalchemist.zombienation.zombies.Zombie_7_Renderer;
import com.madalchemist.zombienation.zombies.Zombie_8_Renderer;
import com.madalchemist.zombienation.zombies.Zombie_9_Renderer;
import java.util.function.Consumer;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemGroup;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="zombienation")
public class Zombienation {
    public static final ItemGroup CREATIVE_TAB = new CreativeTab("zombienation");
    private static final Logger LOGGER = LogManager.getLogger();

    public static <T extends IForgeRegistryEntry<T>> Consumer<RegistryEvent.Register<T>> getRegistrator(Consumer<Registrator<T>> consumer) {
        return event -> consumer.accept(new Registrator(event.getRegistry()));
    }

    public Zombienation() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setupCommon);
        eventBus.addListener(this::setupClient);
        eventBus.addGenericListener(Effect.class, Zombienation.getRegistrator(this::onRegisterEffects));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHandler.spec);
        Zombienation.registerDeferredRegistries(eventBus);
    }

    public void setupCommon(FMLCommonSetupEvent event) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AntizombineRecipe());
    }

    public void setupClient(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.ZOMBIE_1.get()), Zombie_1_Renderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.ZOMBIE_2.get()), Zombie_2_Renderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.ZOMBIE_3.get()), Zombie_3_Renderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.ZOMBIE_4.get()), Zombie_4_Renderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.ZOMBIE_5.get()), Zombie_5_Renderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.ZOMBIE_6.get()), Zombie_6_Renderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.ZOMBIE_7.get()), Zombie_7_Renderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.ZOMBIE_8.get()), Zombie_8_Renderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.ZOMBIE_9.get()), Zombie_9_Renderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.BROWN_BEAR.get()), BrownBearRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ZombiesRegistry.ZOMBIE_BEAR.get()), ZombieBearRenderer::new);
    }

    public static void registerDeferredRegistries(IEventBus modBus) {
        ZombiesRegistry.ENTITY_DEFERRED.register(modBus);
        ModItems.register(modBus);
    }

    public void onRegisterEffects(Registrator<Effect> reg) {
        reg.register(new ResourceLocation("zombienation", "zombie_virus"), (Effect)new PotionZombieVirus(EffectType.HARMFUL, 0));
    }
}

