/*
 * Decompiled with CFR 0.152.
 */
package com.madalchemist.zombienation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.madalchemist.zombienation.Zombienation;
import com.madalchemist.zombienation.animals.BrownBearEntity;
import com.madalchemist.zombienation.zombies.Zombie1;
import com.madalchemist.zombienation.zombies.Zombie2;
import com.madalchemist.zombienation.zombies.Zombie3;
import com.madalchemist.zombienation.zombies.Zombie4;
import com.madalchemist.zombienation.zombies.Zombie5;
import com.madalchemist.zombienation.zombies.Zombie6;
import com.madalchemist.zombienation.zombies.Zombie7;
import com.madalchemist.zombienation.zombies.Zombie8;
import com.madalchemist.zombienation.zombies.Zombie9;
import com.madalchemist.zombienation.zombies.ZombieBear;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="zombienation", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ZombiesRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"zombienation");
    private static List<EntityType> entities = Lists.newArrayList();
    private static final List<Item> SPAWN_EGGS = Lists.newArrayList();
    public static final RegistryObject<EntityType<Zombie1>> ZOMBIE_1 = ZombiesRegistry.createEntity("zombie_1", Zombie1::new, 0.8f, 1.95f, 26112, 0x222222);
    public static final RegistryObject<EntityType<Zombie2>> ZOMBIE_2 = ZombiesRegistry.createEntity("zombie_2", Zombie2::new, 0.8f, 1.95f, 34816, 0x332211);
    public static final RegistryObject<EntityType<Zombie3>> ZOMBIE_3 = ZombiesRegistry.createEntity("zombie_3", Zombie3::new, 0.8f, 1.95f, 43520, 0x442200);
    public static final RegistryObject<EntityType<Zombie4>> ZOMBIE_4 = ZombiesRegistry.createEntity("zombie_4", Zombie4::new, 0.8f, 1.95f, 0x22DD22, 0x445555);
    public static final RegistryObject<EntityType<Zombie5>> ZOMBIE_5 = ZombiesRegistry.createEntity("zombie_5", Zombie5::new, 0.8f, 1.95f, 0xFFFF00, 39168);
    public static final RegistryObject<EntityType<Zombie6>> ZOMBIE_6 = ZombiesRegistry.createEntity("zombie_6", Zombie6::new, 0.8f, 1.95f, 0xFF8888, 39168);
    public static final RegistryObject<EntityType<Zombie7>> ZOMBIE_7 = ZombiesRegistry.createEntity("zombie_7", Zombie7::new, 0.8f, 1.95f, 0xFF0000, 255);
    public static final RegistryObject<EntityType<Zombie8>> ZOMBIE_8 = ZombiesRegistry.createEntity("zombie_8", Zombie8::new, 0.8f, 1.95f, 0xFF0000, 65535);
    public static final RegistryObject<EntityType<Zombie9>> ZOMBIE_9 = ZombiesRegistry.createEntity("zombie_9", Zombie9::new, 0.8f, 1.95f, 0x558855, 0x884488);
    public static final RegistryObject<EntityType<ZombieBear>> ZOMBIE_BEAR = ZombiesRegistry.createEntity("zombie_bear", ZombieBear::new, 1.3f, 1.4f, 0x558855, 0x55FF55);
    public static final RegistryObject<EntityType<BrownBearEntity>> BROWN_BEAR = ZombiesRegistry.createEntity("brown_bear", false, BrownBearEntity::new, 1.3f, 1.4f, 8733957, 0);

    private static <T extends MonsterEntity> RegistryObject<EntityType<T>> createEntity(String name, EntityType.IFactory<T> factory, float width, float height, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("zombienation", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MONSTER).func_220321_a(width, height).setTrackingRange(64).setUpdateInterval(1).func_206830_a(location.toString());
        entities.add(entity);
        SpawnEggItem spawnEgg = new SpawnEggItem(entity, eggPrimary, eggSecondary, new Item.Properties().func_200916_a(Zombienation.CREATIVE_TAB));
        spawnEgg.setRegistryName(new ResourceLocation("zombienation", name + "_spawn_egg"));
        SPAWN_EGGS.add((Item)spawnEgg);
        return ENTITY_DEFERRED.register(name, () -> entity);
    }

    private static <T extends AnimalEntity> RegistryObject<EntityType<T>> createEntity(String name, boolean isMonster, EntityType.IFactory<T> factory, float width, float height, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("zombienation", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.CREATURE).func_220321_a(width, height).setTrackingRange(64).setUpdateInterval(1).func_206830_a(location.toString());
        entities.add(entity);
        SpawnEggItem spawnEgg = new SpawnEggItem(entity, eggPrimary, eggSecondary, new Item.Properties().func_200916_a(Zombienation.CREATIVE_TAB));
        spawnEgg.setRegistryName(new ResourceLocation("zombienation", name + "_spawn_egg"));
        SPAWN_EGGS.add((Item)spawnEgg);
        return ENTITY_DEFERRED.register(name, () -> entity);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ZOMBIE_1.get(), Zombie1.func_234342_eQ_().func_233813_a_());
        event.put((EntityType)ZOMBIE_2.get(), Zombie2.func_234342_eQ_().func_233813_a_());
        event.put((EntityType)ZOMBIE_3.get(), Zombie3.func_234342_eQ_().func_233813_a_());
        event.put((EntityType)ZOMBIE_4.get(), Zombie4.func_234342_eQ_().func_233813_a_());
        event.put((EntityType)ZOMBIE_5.get(), Zombie5.func_234342_eQ_().func_233813_a_());
        event.put((EntityType)ZOMBIE_6.get(), Zombie6.func_234342_eQ_().func_233813_a_());
        event.put((EntityType)ZOMBIE_7.get(), Zombie7.func_234342_eQ_().func_233813_a_());
        event.put((EntityType)ZOMBIE_8.get(), Zombie8.func_234342_eQ_().func_233813_a_());
        event.put((EntityType)ZOMBIE_9.get(), Zombie9.func_234342_eQ_().func_233813_a_());
        event.put((EntityType)BROWN_BEAR.get(), BrownBearEntity.createAttributes().func_233813_a_());
        event.put((EntityType)ZOMBIE_BEAR.get(), ZombieBear.createAttributes().func_233813_a_());
    }

    @SubscribeEvent
    public static void registerZombies(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType entity : entities) {
            Preconditions.checkNotNull((Object)entity.getRegistryName(), (Object)"registryName");
            event.getRegistry().register((IForgeRegistryEntry)entity);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        }
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        for (Item spawnEgg : SPAWN_EGGS) {
            Preconditions.checkNotNull((Object)spawnEgg.getRegistryName(), (Object)"registryName");
            event.getRegistry().register((IForgeRegistryEntry)spawnEgg);
        }
    }
}

