/*
 * Decompiled with CFR 0.152.
 */
package com.madalchemist.zombienation.animals;

import com.madalchemist.zombienation.ZombiesRegistry;
import com.madalchemist.zombienation.zombies.ZombieBear;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BrownBearEntity
extends PolarBearEntity {
    private static final DataParameter<Boolean> DATA_STANDING_ID = EntityDataManager.func_187226_a(BrownBearEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float clientSideStandAnimationO;
    private float clientSideStandAnimation;
    private int warningSoundTicks;
    private static final RangedInteger PERSISTENT_ANGER_TIME = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public BrownBearEntity(EntityType<? extends BrownBearEntity> p_i50249_1_, World p_i50249_2_) {
        super(p_i50249_1_, p_i50249_2_);
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)((EntityType)ZombiesRegistry.BROWN_BEAR.get()).func_200721_a((World)p_241840_1_);
    }

    public boolean func_70877_b(ItemStack p_70877_1_) {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((BrownBearEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, FoxEntity.class, 10, true, true, (Predicate)null));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, 10, true, true, (Predicate)null));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieBear.class, 10, true, true, (Predicate)null));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieHorseEntity.class, 10, true, true, (Predicate)null));
        this.field_70715_bh.func_75776_a(5, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 15.0);
    }

    public static boolean checkBrownBearSpawnRules(EntityType<BrownBearEntity> p_223320_0_, IWorld p_223320_1_, SpawnReason p_223320_2_, BlockPos p_223320_3_, Random p_223320_4_) {
        return BrownBearEntity.func_223316_b(p_223320_0_, (IWorld)p_223320_1_, (SpawnReason)p_223320_2_, (BlockPos)p_223320_3_, (Random)p_223320_4_);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (!this.field_70170_p.field_72995_K) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, p_70037_1_);
        }
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        this.func_233682_c_(p_213281_1_);
    }

    public void func_230258_H__() {
        this.func_230260_a__(PERSISTENT_ANGER_TIME.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int p_230260_1_) {
        this.remainingPersistentAngerTime = p_230260_1_;
    }

    public int func_230256_F__() {
        return this.remainingPersistentAngerTime;
    }

    public void func_230259_a_(@Nullable UUID p_230259_1_) {
        this.persistentAngerTarget = p_230259_1_;
    }

    public UUID func_230257_G__() {
        return this.persistentAngerTarget;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? SoundEvents.field_190027_es : SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected void func_189796_de() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_STANDING_ID, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideStandAnimation != this.clientSideStandAnimationO) {
                this.func_213323_x_();
            }
            this.clientSideStandAnimationO = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.func_189793_df() ? MathHelper.func_76131_a((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        if (this.clientSideStandAnimation > 0.0f) {
            float f = this.clientSideStandAnimation / 6.0f;
            float f1 = 1.0f + f;
            return super.func_213305_a(p_213305_1_).func_220312_a(1.0f, f1);
        }
        return super.func_213305_a(p_213305_1_);
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        boolean flag = p_70652_1_.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (flag) {
            this.func_174815_a((LivingEntity)this, p_70652_1_);
        }
        return flag;
    }

    public boolean func_189793_df() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_STANDING_ID);
    }

    public void func_189794_p(boolean p_189794_1_) {
        this.field_70180_af.func_187227_b(DATA_STANDING_ID, (Object)p_189794_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_189795_r(float p_189795_1_) {
        return MathHelper.func_219799_g((float)p_189795_1_, (float)this.clientSideStandAnimationO, (float)this.clientSideStandAnimation) / 6.0f;
    }

    protected float func_189749_co() {
        return 0.98f;
    }

    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        if (p_213386_4_ == null) {
            p_213386_4_ = new AgeableEntity.AgeableData(1.0f);
        }
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)BrownBearEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !BrownBearEntity.this.func_70631_g_() && !BrownBearEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)BrownBearEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
                BrownBearEntity.this.func_189794_p(false);
            } else if (p_190102_2_ <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    BrownBearEntity.this.func_189794_p(false);
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    BrownBearEntity.this.func_189794_p(true);
                    BrownBearEntity.this.func_189796_de();
                }
            } else {
                this.func_234039_g_();
                BrownBearEntity.this.func_189794_p(false);
            }
        }

        public void func_75251_c() {
            BrownBearEntity.this.func_189794_p(false);
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return 4.0f + p_179512_1_.func_213311_cf();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)BrownBearEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (BrownBearEntity.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity p_220793_1_, LivingEntity p_220793_2_) {
            if (p_220793_1_ instanceof BrownBearEntity && !p_220793_1_.func_70631_g_()) {
                super.func_220793_a(p_220793_1_, p_220793_2_);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)BrownBearEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (BrownBearEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (BrownBearEntity bear : BrownBearEntity.this.field_70170_p.func_217357_a(BrownBearEntity.class, BrownBearEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!bear.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }
}

