/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.blocks.tileentities;

import com.hungteen.pvzmod.blocks.special.BlockJuicer;
import com.hungteen.pvzmod.registry.ItemRegister;
import com.hungteen.pvzmod.util.enums.Juices;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityJuicer
extends TileEntity
implements ITickable {
    private ItemStackHandler handler = new ItemStackHandler(3);
    private String customName;
    private final int MAX_V = 8;
    private final int MAX_WORK_TIME = 100;
    private final int MAX_FLOW_TIME = 100;
    private int burnTime;
    private int burnMaxTime;
    private int workTime;
    private int progress;
    private int flowTime;
    private int type;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.burnTime = compound.func_74762_e("BurnTime");
        this.burnMaxTime = compound.func_74762_e("BurnMaxTime");
        this.workTime = compound.func_74762_e("WorkTime");
        this.flowTime = compound.func_74762_e("FlowTime");
        this.progress = compound.func_74762_e("Progress");
        this.type = compound.func_74762_e("Type");
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(compound.func_74779_i("CustomName"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("BurnMaxTime", this.burnMaxTime);
        compound.func_74768_a("WorkTime", this.workTime);
        compound.func_74768_a("FlowTime", this.flowTime);
        compound.func_74768_a("Progress", this.progress);
        compound.func_74768_a("Type", this.type);
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public void func_73660_a() {
        boolean is_burn = this.isBurning();
        boolean change = false;
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fruit = this.handler.getStackInSlot(0);
            ItemStack fuel = this.handler.getStackInSlot(1);
            ItemStack bucket = this.handler.getStackInSlot(2);
            if (this.isBurning() || !fruit.func_190926_b() && !fuel.func_190926_b()) {
                if (!this.isBurning() && this.progress < this.MAX_V) {
                    int time = TileEntityJuicer.getItemBurnTime(fuel);
                    if (this.checkFruit(fruit) && time != 0) {
                        this.burnTime = time;
                        this.burnMaxTime = time;
                        if (this.isBurning()) {
                            change = true;
                            fuel.func_190918_g(1);
                        }
                    }
                }
                if (this.isBurning() && this.progress < this.MAX_V && this.checkFruit(fruit)) {
                    ++this.workTime;
                    ((Object)((Object)this)).getClass();
                    if (this.workTime >= 100) {
                        this.workTime = 0;
                        if (this.type == 0) {
                            if (fruit.func_77973_b() == Items.field_151034_e) {
                                this.type = Juices.APPLE_JUICE.ordinal();
                            } else if (fruit.func_77973_b() == Items.field_151127_ba) {
                                this.type = Juices.MELON_JUICE.ordinal();
                            }
                        }
                        fruit.func_190918_g(1);
                        ++this.progress;
                        change = true;
                    }
                } else {
                    this.workTime = 0;
                }
                if (this.isBurning() != is_burn) {
                    change = true;
                    BlockJuicer.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
                }
                if (this.isBurning()) {
                    --this.burnTime;
                }
            }
            if (this.progress > 0 && !bucket.func_190926_b() && bucket.func_77973_b() == ItemRegister.GLASS_CUP) {
                ++this.flowTime;
                ((Object)((Object)this)).getClass();
                if (this.flowTime >= 100) {
                    this.flowTime = 0;
                    --this.progress;
                    if (this.progress == 0) {
                        this.type = 0;
                    }
                    if (this.type == Juices.APPLE_JUICE.ordinal()) {
                        this.handler.setStackInSlot(2, new ItemStack(ItemRegister.APPLE_JUICE, 1));
                    } else if (this.type == Juices.MELON_JUICE.ordinal()) {
                        this.handler.setStackInSlot(2, new ItemStack(ItemRegister.MELON_JUICE, 1));
                    }
                    change = true;
                }
            } else {
                this.flowTime = 0;
            }
            if (change) {
                this.func_70296_d();
            }
        }
    }

    private boolean checkFruit(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        Juices juice = Juices.values()[this.type];
        if (item == Items.field_151034_e && (juice == Juices.NONE || juice == Juices.APPLE_JUICE)) {
            return true;
        }
        return item == Items.field_151127_ba && (juice == Juices.NONE || juice == Juices.MELON_JUICE);
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151137_ax) {
            return 200;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150451_bX)) {
            return 2000;
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack fuel) {
        return TileEntityJuicer.getItemBurnTime(fuel) > 0;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(TileEntityJuicer te) {
        return te.getField(0) > 0;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.workTime;
            }
            case 2: {
                return this.flowTime;
            }
            case 3: {
                return this.progress;
            }
            case 4: {
                return this.type;
            }
            case 5: {
                return this.burnMaxTime;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.workTime = value;
                break;
            }
            case 2: {
                this.flowTime = value;
                break;
            }
            case 3: {
                this.progress = value;
                break;
            }
            case 4: {
                this.type = value;
                break;
            }
            case 5: {
                this.burnMaxTime = value;
            }
        }
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.customName) : new TextComponentTranslation("container.pvz_juicer", new Object[0]);
    }
}

