/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.capability.data;

import com.hungteen.pvzmod.packet.PacketHandler;
import com.hungteen.pvzmod.packet.PacketPlantLvlData;
import com.hungteen.pvzmod.packet.PacketPlayerData;
import com.hungteen.pvzmod.util.PlantsUtil;
import com.hungteen.pvzmod.util.PlayerUtil;
import com.hungteen.pvzmod.util.enums.Plants;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerDataManager {
    private final EntityPlayer player;
    private final PlayerStats playerStats;
    private final PlantStats plantStats;

    public PlayerDataManager(EntityPlayer player) {
        this.player = player;
        this.playerStats = new PlayerStats(this);
        this.plantStats = new PlantStats(this);
    }

    public NBTTagCompound saveToNBT() {
        NBTTagCompound baseTag = new NBTTagCompound();
        this.playerStats.saveToNBT(baseTag);
        this.plantStats.saveToNBT(baseTag);
        return baseTag;
    }

    public void loadFromNBT(NBTTagCompound baseTag) {
        this.playerStats.loadFromNBT(baseTag);
        this.plantStats.loadFromNBT(baseTag);
    }

    public void cloneFromExistingPlayerData(PlayerDataManager sourcePlayerData) {
        for (Plants plant : Plants.values()) {
            this.plantStats.plantLevel.put(plant, sourcePlayerData.plantStats.plantLevel.get((Object)plant));
            this.plantStats.plantXp.put(plant, sourcePlayerData.plantStats.plantXp.get((Object)plant));
            this.plantStats.isPlantLocked.put(plant, sourcePlayerData.plantStats.getIsPlantLocked(plant));
        }
        this.playerStats.playerEnergyNum = sourcePlayerData.playerStats.playerEnergyNum;
        this.playerStats.playerLevel = sourcePlayerData.playerStats.playerLevel;
        this.playerStats.playerMoney = sourcePlayerData.playerStats.playerMoney;
        this.playerStats.playerSunNum = sourcePlayerData.playerStats.playerSunNum;
        this.playerStats.playerXp = sourcePlayerData.playerStats.playerXp;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public PlayerStats getPlayerStats() {
        return this.playerStats;
    }

    public PlantStats getPlantStats() {
        return this.plantStats;
    }

    public final class PlantStats {
        private final PlayerDataManager playerDataManager;
        private HashMap<Plants, Integer> plantXp = new HashMap(Plants.values().length);
        private HashMap<Plants, Integer> plantLevel = new HashMap(Plants.values().length);
        private HashMap<Plants, Boolean> isPlantLocked = new HashMap(Plants.values().length);

        private PlantStats(PlayerDataManager dataManager) {
            this.playerDataManager = dataManager;
            for (Plants plant : Plants.values()) {
                this.plantXp.put(plant, 0);
                this.plantLevel.put(plant, 1);
                this.isPlantLocked.put(plant, true);
            }
        }

        public int getPlantLevel(Plants plant) {
            return this.plantLevel.get((Object)plant);
        }

        public int getPlantXp(Plants plant) {
            return this.plantXp.get((Object)plant);
        }

        public boolean getIsPlantLocked(Plants plant) {
            return this.isPlantLocked.get((Object)plant);
        }

        public void addPlantLevel(Plants plant, int lvl) {
            int maxLvl;
            int now = this.getPlantLevel(plant) + lvl;
            if (now > (maxLvl = PlantsUtil.getPlantMaxLvl(plant))) {
                now = maxLvl;
            } else if (now < 1) {
                now = 1;
            }
            this.plantLevel.put(plant, now);
            this.sendPlantPacket(PlayerDataManager.this.player, plant);
        }

        public void addPlantXp(Plants plant, int num) {
            int xp;
            int lvl = this.getPlantLevel(plant);
            if (num > 0) {
                int needXp = PlantsUtil.getPlantLvlUpXp(lvl);
                for (xp = this.getPlantXp(plant) + num; xp >= needXp; xp -= needXp) {
                    this.addPlantLevel(plant, 1);
                    lvl = this.getPlantLevel(plant);
                    needXp = PlantsUtil.getPlantLvlUpXp(lvl);
                }
            } else {
                while (xp < 0) {
                    if (lvl == 1) {
                        xp = 0;
                        break;
                    }
                    this.addPlantLevel(plant, -1);
                    lvl = this.getPlantLevel(plant);
                    int needXp = PlantsUtil.getPlantLvlUpXp(lvl);
                    xp += needXp;
                }
            }
            this.plantXp.put(plant, xp);
            this.sendPlantPacket(PlayerDataManager.this.player, plant);
        }

        public void setIsPlantLocked(Plants plant, boolean is) {
            this.isPlantLocked.put(plant, is);
            this.sendPlantPacket(PlayerDataManager.this.player, plant);
        }

        private void sendPlantPacket(EntityPlayer player, Plants plant) {
            if (player instanceof EntityPlayerMP) {
                PacketHandler.CHANNEL.sendTo((IMessage)new PacketPlantLvlData(plant, this.getPlantLevel(plant), this.getPlantXp(plant), this.getIsPlantLocked(plant)), (EntityPlayerMP)player);
            }
        }

        private void saveToNBT(NBTTagCompound baseTag) {
            for (Plants plant : Plants.values()) {
                NBTTagCompound plantNBT = new NBTTagCompound();
                plantNBT.func_74768_a("PlantLevelxx", this.getPlantLevel(plant));
                plantNBT.func_74768_a("PlantExpxx", this.getPlantXp(plant));
                plantNBT.func_74757_a("PlantLockedxx", this.getIsPlantLocked(plant));
                baseTag.func_74782_a(plant.toString(), (NBTBase)plantNBT);
            }
        }

        private void loadFromNBT(NBTTagCompound baseTag) {
            for (Plants plant : Plants.values()) {
                NBTTagCompound plantTag = baseTag.func_74775_l(plant.toString());
                this.plantLevel.put(plant, plantTag.func_74762_e("PlantLevelxx"));
                this.plantXp.put(plant, plantTag.func_74762_e("PlantExpxx"));
                this.isPlantLocked.put(plant, plantTag.func_74767_n("PlantLockedxx"));
            }
        }
    }

    public final class PlayerStats {
        private final PlayerDataManager playerDataManager;
        private int playerMoney;
        private int playerSunNum;
        private int playerEnergyNum;
        private int playerLevel;
        private int playerXp;

        private PlayerStats(PlayerDataManager dataManager) {
            this.playerDataManager = dataManager;
            this.playerSunNum = 50;
            this.playerEnergyNum = 0;
            this.playerMoney = 0;
            this.playerLevel = 1;
            this.playerXp = 0;
        }

        public int getPlayerLevel() {
            return this.playerLevel;
        }

        public int getPlayerXp() {
            return this.playerXp;
        }

        public int getPlayerSunNum() {
            return this.playerSunNum;
        }

        public int getPlayerMoney() {
            return this.playerMoney;
        }

        public int getPlayerEnergyNum() {
            return this.playerEnergyNum;
        }

        public void addPlayerLevel(int lvl) {
            this.playerLevel += lvl;
            if (this.playerLevel >= 100) {
                this.playerLevel = 100;
            }
            this.sendPacket(PlayerDataManager.this.player);
        }

        public void addPlayerXp(int xp) {
            int lvl = this.getPlayerLevel();
            if (xp > 0) {
                this.playerXp += xp;
                int needXp = PlayerUtil.getPlayerLevelUpXp(lvl);
                while (this.playerXp >= needXp) {
                    this.playerXp -= needXp;
                    this.addPlayerLevel(1);
                    lvl = this.getPlayerLevel();
                    needXp = PlayerUtil.getPlayerLevelUpXp(lvl);
                }
            } else {
                this.playerXp -= xp;
                while (this.playerXp < 0) {
                    if (lvl == 1) {
                        this.playerXp = 0;
                        break;
                    }
                    this.addPlayerLevel(-1);
                    this.playerXp += PlayerUtil.getPlayerLevelUpXp(lvl);
                }
            }
            this.sendPacket(PlayerDataManager.this.player);
        }

        public void addPlayerSunNum(int num) {
            int now = this.playerSunNum + num;
            int lvl = this.getPlayerLevel();
            int maxSunNum = PlayerUtil.getPlayerMaxSunNum(lvl);
            if (now > maxSunNum) {
                now = maxSunNum;
            } else if (now < 0) {
                now = 0;
            }
            this.playerSunNum = now;
            this.sendPacket(PlayerDataManager.this.player);
        }

        public void addPlayerMoney(int m) {
            this.playerMoney += m;
            if (this.playerMoney >= 9999999) {
                this.playerMoney = 9999999;
            }
            this.sendPacket(PlayerDataManager.this.player);
        }

        public void addPlayerEnergyNum(int num) {
            int now = this.playerEnergyNum + num;
            int lvl = this.getPlayerLevel();
            int maxNum = PlayerUtil.getPlayerMaxEnergyNum(lvl);
            if (now > maxNum) {
                now = maxNum;
            } else if (now < 0) {
                now = 0;
            }
            this.playerEnergyNum = now;
            this.sendPacket(PlayerDataManager.this.player);
        }

        private void sendPacket(EntityPlayer player) {
            if (player instanceof EntityPlayerMP) {
                PacketHandler.CHANNEL.sendTo((IMessage)new PacketPlayerData(this.playerLevel, this.playerXp, this.playerSunNum, this.playerEnergyNum, this.playerMoney), (EntityPlayerMP)player);
            }
        }

        private void saveToNBT(NBTTagCompound baseTag) {
            NBTTagCompound playerNBT = new NBTTagCompound();
            playerNBT.func_74768_a("PlayerLevelxx", this.playerLevel);
            playerNBT.func_74768_a("PlayerExpxx", this.playerXp);
            playerNBT.func_74768_a("PlayerMoneyxx", this.playerMoney);
            playerNBT.func_74768_a("PlayerSunNumxx", this.playerSunNum);
            playerNBT.func_74768_a("PlayerEnergyNumxx", this.playerEnergyNum);
            baseTag.func_74782_a("PLAYERLEVELxx", (NBTBase)playerNBT);
        }

        private void loadFromNBT(NBTTagCompound baseTag) {
            NBTTagCompound playerTag = baseTag.func_74775_l("PLAYERLEVELxx");
            this.playerLevel = playerTag.func_74762_e("PlayerLevelxx");
            this.playerXp = playerTag.func_74762_e("PlayerExpxx");
            this.playerMoney = playerTag.func_74762_e("PlayerMoneyxx");
            if (playerTag.func_74764_b("PlayerSunNumxx")) {
                this.playerSunNum = playerTag.func_74762_e("PlayerSunNumxx");
            }
            this.playerEnergyNum = playerTag.func_74762_e("PlayerEnergyNumxx");
        }
    }
}

