/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.damage;

import com.hungteen.pvzmod.damage.PVZDamageSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class PVZExplosion {
    boolean damagesTerrain;
    Random random = new Random();
    World world;
    double x;
    double y;
    double z;
    Entity exploder;
    Entity projectile;
    HashMap<BlockPos, Double> affectedBlockPositions = new HashMap();
    float[][][] dmgVolume;
    Vec3d position;
    double primaryRadius;
    double primaryDamage;
    double secondaryRadius;
    double secondaryDamage;
    double blockDamageFactor;
    public float blockDropChance = 0.25f;
    Explosion explosionDummy;
    PVZDamageSource dmgSrc = null;

    public PVZExplosion(World world, Entity exploder, Entity projectile, double x, double y, double z, double primaryDamage, double secondaryDamage, double primaryRadius, double secondaryRadius, double blockDamageFactor) {
        this.world = world;
        this.exploder = exploder;
        this.projectile = projectile;
        this.x = x;
        this.y = y;
        this.z = z;
        this.primaryDamage = primaryDamage;
        this.secondaryDamage = secondaryDamage;
        this.primaryRadius = primaryRadius;
        this.secondaryRadius = secondaryRadius;
        this.blockDamageFactor = blockDamageFactor;
        this.damagesTerrain = blockDamageFactor >= 0.01;
        this.position = new Vec3d(this.x, this.y, this.z);
        this.explosionDummy = new Explosion(world, exploder, x, y, z, (float)Math.max(primaryRadius, secondaryRadius), false, this.damagesTerrain);
    }

    public PVZExplosion setDmgSrc(PVZDamageSource src) {
        this.dmgSrc = src;
        return this;
    }

    public Explosion getExplosionDummy() {
        return this.explosionDummy;
    }

    public void doExplosion(boolean playSound) {
        if (playSound) {
            this.world.func_184148_a((EntityPlayer)null, this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        HashMap<BlockPos, Double> set = new HashMap<BlockPos, Double>();
        double totalRadius = Math.max(this.primaryRadius, this.secondaryRadius);
        int radius = (int)Math.ceil(totalRadius);
        double stepOffset = 0.3f;
        int steps = (int)Math.ceil((double)radius / stepOffset);
        for (int j = -radius; j < radius; ++j) {
            for (int k = -radius; k < radius; ++k) {
                for (int l = -radius; l < radius; ++l) {
                    if (j != -radius && j != radius - 1 && k != -radius && k != radius - 1 && l != -radius && l != radius - 1) continue;
                    double dx = (float)j / (float)radius;
                    double dy = (float)k / (float)radius;
                    double dz = (float)l / (float)radius;
                    double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    dx /= length;
                    dy /= length;
                    dz /= length;
                    double px = 0.0;
                    double py = 0.0;
                    double pz = 0.0;
                    float dmgFactor = 1.0f;
                    double explosionDamping = 0.0;
                    double explosionPower = this.primaryDamage;
                    BlockPos prevPos = null;
                    for (int i = 0; i < steps && explosionPower > 0.0; ++i) {
                        BlockPos blockpos = new BlockPos(this.x + px, this.y + py, this.z + pz);
                        IBlockState iblockstate = this.world.func_180495_p(blockpos);
                        double distance = this.position.func_72438_d(new Vec3d((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5));
                        explosionPower = distance <= this.primaryRadius ? this.primaryDamage : (distance <= this.secondaryRadius ? this.secondaryDamage + (distance - this.primaryRadius) / (this.secondaryRadius - this.primaryRadius) * (this.primaryDamage - this.secondaryDamage) : 0.0);
                        float resistance = 0.0f;
                        if (iblockstate.func_185904_a() != Material.field_151579_a) {
                            resistance = iblockstate.func_177230_c().getExplosionResistance(this.world, blockpos, this.exploder, this.explosionDummy);
                            if (explosionPower - explosionDamping > 0.0 && (double)resistance < (explosionPower - explosionDamping) * this.blockDamageFactor && (this.exploder == null || this.exploder.func_174816_a(this.explosionDummy, this.world, blockpos, iblockstate, (float)explosionPower))) {
                                set.put(blockpos, distance);
                                if (prevPos == null || prevPos.func_177958_n() != blockpos.func_177958_n() || prevPos.func_177956_o() != blockpos.func_177956_o() || prevPos.func_177952_p() != blockpos.func_177952_p()) {
                                    explosionDamping += (double)resistance;
                                }
                            } else {
                                explosionPower = 0.0;
                            }
                        }
                        px += dx * stepOffset;
                        py += dy * stepOffset;
                        pz += dz * stepOffset;
                        prevPos = blockpos;
                    }
                }
            }
        }
        this.affectedBlockPositions.putAll(set);
        float f3 = (float)totalRadius;
        int k1 = MathHelper.func_76128_c((double)(this.x - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.x + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.y - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.y + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.z - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.z + (double)f3 + 1.0));
        List list = this.world.func_72839_b(this.projectile, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this.explosionDummy, (List)list, (double)f3);
        Vec3d vec3d = new Vec3d(this.x, this.y, this.z);
        this.breakBlocks();
        PVZDamageSource tgs = this.dmgSrc == null ? PVZDamageSource.causeExplosionDamage(this.projectile, this.exploder) : PVZDamageSource.copyWithNewEnt(this.dmgSrc, this.projectile, this.exploder);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Vec3d end;
            Vec3d start;
            RayTraceResult rtr;
            Entity entity = (Entity)list.get(k2);
            if (entity.func_180427_aV()) continue;
            double distance = this.position.func_72438_d(new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v));
            double damage = distance <= this.primaryRadius ? this.primaryDamage : (distance <= this.secondaryRadius ? this.secondaryDamage + (distance - this.primaryRadius) / (this.secondaryRadius - this.primaryRadius) * (this.primaryDamage - this.secondaryDamage) : 0.0);
            if (damage > 0.0 && (rtr = this.world.func_147447_a(start = this.position, end = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() * 0.5, entity.field_70161_v), false, true, false)) != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK) {
                damage = 0.0;
            }
            if (!(damage > 0.0)) continue;
            entity.func_70097_a((DamageSource)tgs, (float)Math.max(0.0, damage));
        }
    }

    private void breakBlocks() {
        if (this.damagesTerrain) {
            double r = this.secondaryRadius - this.primaryRadius;
            for (Map.Entry<BlockPos, Double> entry : this.affectedBlockPositions.entrySet()) {
                BlockPos blockpos = entry.getKey();
                IBlockState iblockstate = this.world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                if (entry.getValue() > this.primaryRadius && Math.random() < (double)this.blockDropChance * (entry.getValue() - this.primaryRadius) / r && block.func_149659_a(this.explosionDummy)) {
                    block.func_180653_a(this.world, blockpos, this.world.func_180495_p(blockpos), 1.0f, 0);
                }
                block.onBlockExploded(this.world, blockpos, this.explosionDummy);
            }
        }
    }
}

