/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.ai;

import com.hungteen.pvzmod.util.AIUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class EntityAIDestroyBlocks
extends EntityAIBase {
    private EntityLivingBase target;
    private EntityLiving attacker;
    private BlockPos block;
    private int scanTick;
    private int digTick;

    public EntityAIDestroyBlocks(EntityLiving attacker) {
        this.attacker = attacker;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        this.target = this.attacker.func_70638_az();
        if (this.target != null && this.target.func_70089_S() && this.attacker.func_70661_as().func_75500_f() && (double)this.attacker.func_70032_d((Entity)this.target) > 1.0) {
            if (this.block == null || !(this.attacker.func_174818_b(this.block) <= 16.0) || !this.canHarvest(this.attacker, this.block)) {
                this.block = this.getNextBlock(this.attacker, this.target, 2.0);
            }
            return this.block != null;
        }
        return false;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.block = null;
        this.digTick = 0;
    }

    public boolean func_75253_b() {
        return this.block != null && this.attacker.func_174818_b(this.block) <= 16.0 && this.canHarvest(this.attacker, this.block);
    }

    public void func_75246_d() {
        if (!this.func_75253_b()) {
            return;
        }
        this.attacker.func_70671_ap().func_75650_a(this.target.field_70165_t, this.target.field_70163_u + (double)this.target.func_70047_e(), this.target.field_70161_v, (float)this.attacker.func_184649_cE(), (float)this.attacker.func_70646_bf());
        this.attacker.func_70661_as().func_75499_g();
        ++this.digTick;
        float str = AIUtil.getBlockStrength((EntityLivingBase)this.attacker, this.attacker.field_70170_p, this.block) * ((float)this.digTick + 1.0f);
        ItemStack heldItem = this.attacker.func_184586_b(EnumHand.MAIN_HAND);
        IBlockState state = this.attacker.field_70170_p.func_180495_p(this.block);
        if (this.attacker.field_70170_p.func_175623_d(this.block)) {
            this.func_75251_c();
        } else if (str >= 1.0f) {
            boolean canHarvest = state.func_185904_a().func_76229_l() || !heldItem.func_190926_b() && heldItem.func_150998_b(state);
            this.attacker.field_70170_p.func_175655_b(this.block, canHarvest);
            this.attacker.func_70661_as().func_75484_a(this.attacker.func_70661_as().func_75494_a((Entity)this.target), this.attacker.func_70605_aq().func_75638_b());
            this.func_75251_c();
        } else if (this.digTick % 5 == 0) {
            this.attacker.field_70170_p.func_184133_a(null, this.block, state.func_177230_c().getSoundType(state, this.attacker.field_70170_p, this.block, (Entity)this.attacker).func_185846_f(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.attacker.func_184609_a(EnumHand.MAIN_HAND);
            this.attacker.field_70170_p.func_175715_c(this.attacker.func_145782_y(), this.block, (int)(str * 10.0f));
        }
    }

    private BlockPos getNextBlock(EntityLiving digger, EntityLivingBase target, double dis) {
        BlockPos p2;
        int digWidth = MathHelper.func_76123_f((float)digger.field_70130_N);
        int digHeight = MathHelper.func_76123_f((float)digger.field_70131_O);
        int passMax = digWidth * digHeight * digWidth;
        int x = this.scanTick / (digWidth * digHeight);
        int y = this.scanTick % (digWidth * digHeight) / digWidth;
        int z = this.scanTick % digWidth;
        double rayX = (double)x + digger.field_70165_t - (double)(digWidth / 2);
        double rayY = (double)y + digger.field_70163_u + 0.5;
        double rayZ = (double)z + digger.field_70161_v - (double)(digWidth / 2);
        Vec3d rayS = new Vec3d(rayX, rayY, rayZ);
        Vec3d rayT = this.target.func_174791_d();
        rayT = rayS.func_178787_e(rayT.func_178788_d(rayS).func_72432_b().func_186678_a(dis));
        BlockPos p1 = digger.func_180425_c();
        if (p1.func_185332_f((p2 = target.func_180425_c()).func_177958_n(), p1.func_177956_o(), p2.func_177952_p()) < 4.0) {
            if ((double)(p2.func_177956_o() - p1.func_177956_o()) > 2.0) {
                rayT = rayS.func_72441_c(0.0, dis, 0.0);
            } else if ((double)(p2.func_177956_o() - p1.func_177956_o()) < 2.0) {
                rayT = rayS.func_72441_c(0.0, -dis, 0.0);
            }
        }
        RayTraceResult ray = digger.field_70170_p.func_147447_a(rayS, rayT, false, true, false);
        this.scanTick = (this.scanTick + 1) % passMax;
        if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ray.func_178782_a();
            IBlockState state = digger.field_70170_p.func_180495_p(pos);
            if (this.canHarvest(digger, pos)) {
                return pos;
            }
        }
        return null;
    }

    private boolean canHarvest(EntityLiving entity, BlockPos pos) {
        IBlockState state = entity.field_70170_p.func_180495_p(pos);
        if (!state.func_185904_a().func_76220_a() || state.func_185887_b(entity.field_70170_p, pos) < 0.0f) {
            return false;
        }
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        return true;
    }
}

