/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.bullets;

import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.entities.bullets.EntityPult;
import com.hungteen.pvzmod.entities.plants.base.EntityPultBase;
import com.hungteen.pvzmod.entities.plants.common.EntityMelonPult;
import com.hungteen.pvzmod.util.EntityUtil;
import com.hungteen.pvzmod.util.SoundsHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityMelon
extends EntityPult {
    private static final DataParameter<Integer> MELON_STATE = EntityDataManager.func_187226_a(EntityMelon.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityMelon(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 0.5f);
    }

    public EntityMelon(World world, EntityPultBase pult, EntityPult.Type down, State state) {
        super(world, (EntityLivingBase)pult, down);
        this.setMelonState(state);
        this.func_70105_a(1.5f, 0.5f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MELON_STATE, (Object)State.NORMAL.ordinal());
    }

    @Override
    protected void performSpiltDamage() {
        if (this.shooter instanceof EntityMelonPult) {
            float damage = ((EntityMelonPult)this.shooter).getSpiltDamage();
            float len = this.getSpiltDis();
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - (double)len, this.field_70163_u - (double)len, this.field_70161_v - (double)len, this.field_70165_t + (double)len, this.field_70163_u + (double)len, this.field_70161_v + (double)len);
            for (Entity entity : EntityUtil.getEntityAttackableTarget(this.func_85052_h(), aabb)) {
                if (this.getMelonState() == State.ICE) {
                    entity.func_70097_a((DamageSource)PVZDamageSource.causeSnowDamage((Entity)this, (Entity)this.shooter), damage);
                    continue;
                }
                entity.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this.shooter), damage);
            }
            this.func_184185_a(SoundsHandler.MELON_HIT, 1.0f, 1.0f);
        }
    }

    private float getSpiltDis() {
        return 1.5f;
    }

    @Override
    protected void spawnDeathParticle() {
        for (int i = 1; i <= 20; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)(this.field_70146_Z.nextFloat() - 0.5f), (double)this.field_70146_Z.nextFloat(), (double)(this.field_70146_Z.nextFloat() - 0.5f), new int[0]);
        }
    }

    @Override
    protected EntityPult getPultBullet(EntityPultBase pult) {
        return new EntityMelon(this.field_70170_p, pult, EntityPult.Type.DOWN, this.getMelonState());
    }

    @Override
    protected float getAttackDamage() {
        float damage = 0.0f;
        if (this.shooter instanceof EntityMelonPult) {
            damage = ((EntityMelonPult)this.shooter).getAttackDamage();
        }
        if (this.getPultType() != EntityPult.Type.NORMAL) {
            damage += 20.0f;
        }
        return damage;
    }

    public State getMelonState() {
        return State.values()[(Integer)this.field_70180_af.func_187225_a(MELON_STATE)];
    }

    public void setMelonState(State state) {
        this.field_70180_af.func_187227_b(MELON_STATE, (Object)state.ordinal());
    }

    public static enum State {
        NORMAL,
        ICE;

    }
}

