/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.bullets;

import com.hungteen.pvzmod.Main;
import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.entities.bullets.PVZThrowable;
import com.hungteen.pvzmod.entities.plants.base.EntityPlantBase;
import com.hungteen.pvzmod.entities.plants.flame.EntityTorchWood;
import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.particles.base.PVZParticleType;
import com.hungteen.pvzmod.util.SoundsHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPea
extends PVZThrowable {
    private static final DataParameter<Integer> PEA_STATE = EntityDataManager.func_187226_a(EntityPea.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PEA_TYPE = EntityDataManager.func_187226_a(EntityPea.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityTorchWood torchWood = null;

    public EntityPea(World worldIn) {
        super(worldIn);
    }

    public EntityPea(World worldIn, EntityLivingBase throwerIn, Type type, State state) {
        super(worldIn, throwerIn);
        this.setPeaState(state);
        this.setPeaType(type);
        if (type == Type.NORMAL) {
            this.func_70105_a(0.25f, 0.25f);
        } else if (type == Type.BIG) {
            this.func_70105_a(0.4f, 0.4f);
        } else if (type == Type.HUGE) {
            this.func_70105_a(0.6f, 0.6f);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PEA_STATE, (Object)State.NORMAL.ordinal());
        this.field_70180_af.func_187214_a(PEA_TYPE, (Object)Type.NORMAL.ordinal());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("peaState", this.getPeaState().ordinal());
        compound.func_74768_a("peaType", this.getPeaType().ordinal());
    }

    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setPeaState(State.values()[compund.func_74762_e("peaState")]);
        this.setPeaType(Type.values()[compund.func_74762_e("peaType")]);
    }

    public static void registerFixesPea(DataFixer fixer) {
        EntityThrowable.func_189661_a((DataFixer)fixer, (String)"Pea");
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.playParticle();
    }

    private void playParticle() {
        if (this.shooter instanceof EntityPlantBase) {
            int lvl = ((EntityPlantBase)this.shooter).getPlantLvl();
            if (lvl > 4 && lvl <= 12) {
                Main.proxy.spawnParticle(PVZParticleType.SPEED_PEA_ONE, this.field_70169_q, this.field_70167_r, this.field_70166_s, 0.0, 0.0, 0.0);
            } else if (lvl >= 13 && lvl <= 20) {
                Main.proxy.spawnParticle(PVZParticleType.SPEED_PEA_TWO, this.field_70169_q, this.field_70167_r, this.field_70166_s, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        Entity target = result.field_72308_g;
        if (this.checkCanAttack(target)) {
            if (this.getPeaState() == State.NORMAL) {
                target.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this.func_85052_h()), this.getAttackDamage());
            } else if (this.getPeaState() == State.SNOW) {
                if (target instanceof EntityZombieBase && !this.field_70170_p.field_72995_K && !((EntityZombieBase)target).getIsCold()) {
                    this.func_184185_a(SoundsHandler.FROZEN_PEA, 4.0f, 1.0f);
                }
                target.func_70097_a((DamageSource)PVZDamageSource.causeSnowDamage((Entity)this, (Entity)this.func_85052_h()), this.getAttackDamage());
            } else if (this.getPeaState() == State.FIRE || this.getPeaState() == State.BLUE_FIRE) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_184185_a(SoundsHandler.FIRE_PEA, 4.0f, 1.0f);
                }
                target.func_70097_a((DamageSource)PVZDamageSource.causeFireDamage((Entity)this, (Entity)this.func_85052_h()), this.getAttackDamage());
            }
        }
        if (!this.field_70170_p.field_72995_K && target instanceof EntityTorchWood) {
            EntityTorchWood tmp = (EntityTorchWood)target;
            if (this.torchWood == null || !this.torchWood.func_70028_i((Entity)tmp)) {
                this.torchWood = tmp;
                if (this.torchWood.isPlantInSuperMode()) {
                    if (this.getPeaState() == State.SNOW) {
                        this.setPeaState(State.FIRE);
                    } else if (this.getPeaState().ordinal() < State.BLUE_FIRE.ordinal()) {
                        this.setPeaState(State.BLUE_FIRE);
                    }
                } else if (this.getPeaState() == State.SNOW) {
                    this.setPeaState(State.NORMAL);
                } else if (this.getPeaState() == State.NORMAL) {
                    this.setPeaState(State.FIRE);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            if (!this.checkLive(result)) {
                this.func_70106_y();
            }
        }
    }

    @Override
    protected boolean checkCanAttack(Entity target) {
        if (target instanceof EntityTorchWood) {
            return false;
        }
        return super.checkCanAttack(target);
    }

    private float getAttackDamage() {
        float damage = 0.0f;
        if (this.shooter instanceof EntityPlantBase) {
            damage = ((EntityPlantBase)this.shooter).getAttackDamage();
        } else if (this.shooter instanceof EntityZombieBase) {
            damage = 3.0f;
        } else if (this.shooter instanceof EntityPlayer) {
            damage = 4.0f;
        }
        if (this.getPeaType() == Type.BIG) {
            damage += 20.0f;
        } else if (this.getPeaType() == Type.HUGE) {
            damage += 75.0f;
        }
        if (this.getPeaState() == State.FIRE) {
            damage *= 2.0f;
        } else if (this.getPeaState() == State.BLUE_FIRE) {
            damage *= 3.0f;
        }
        return damage;
    }

    public State getPeaState() {
        return State.values()[(Integer)this.field_70180_af.func_187225_a(PEA_STATE)];
    }

    public void setPeaState(State state) {
        this.field_70180_af.func_187227_b(PEA_STATE, (Object)state.ordinal());
    }

    public Type getPeaType() {
        return Type.values()[(Integer)this.field_70180_af.func_187225_a(PEA_TYPE)];
    }

    public void setPeaType(Type type) {
        this.field_70180_af.func_187227_b(PEA_TYPE, (Object)type.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
    }

    protected float func_70185_h() {
        return 0.003f;
    }

    public static enum State {
        SNOW,
        NORMAL,
        FIRE,
        BLUE_FIRE,
        ELECTRICITY;

    }

    public static enum Type {
        NORMAL,
        BIG,
        HUGE;

    }
}

