/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.bullets;

import com.hungteen.pvzmod.Main;
import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.entities.bullets.PVZThrowable;
import com.hungteen.pvzmod.entities.plants.base.EntityPultBase;
import com.hungteen.pvzmod.particles.base.PVZParticleType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public abstract class EntityPult
extends PVZThrowable {
    private static final DataParameter<Integer> PULT_TYPE = EntityDataManager.func_187226_a(EntityPult.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityPult(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PULT_TYPE, (Object)Type.NORMAL.ordinal());
    }

    public EntityPult(World worldIn, EntityLivingBase throwerIn, Type type) {
        super(worldIn, throwerIn);
        this.setPultType(type);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getPultType() == Type.EXPLODE && this.field_70181_x < 0.0) {
            this.explode();
        }
        if (this.getPultType() != Type.NORMAL) {
            for (int i = 0; i < 3; ++i) {
                Main.proxy.spawnParticle(PVZParticleType.SPEED_PEA_TWO, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            }
        }
        this.field_70159_w /= (double)0.99f;
        this.field_70181_x /= (double)0.99f;
        this.field_70179_y /= (double)0.99f;
    }

    @Override
    public void shoot(double dx, double dy, double dz) {
        if (this.getPultType() == Type.EXPLODE) {
            this.field_70181_x = 2.0;
            return;
        }
        super.shoot(dx, dy, dz);
    }

    protected void explode() {
        if (this.func_85052_h() instanceof EntityPultBase) {
            if (!this.field_70170_p.field_72995_K) {
                EntityPultBase pult = (EntityPultBase)this.func_85052_h();
                int r = pult.getRange();
                AxisAlignedBB aabb = new AxisAlignedBB(pult.field_70165_t - (double)r, pult.field_70163_u - 5.0, pult.field_70161_v - (double)r, pult.field_70165_t + (double)r, pult.field_70163_u + 20.0, pult.field_70161_v + (double)r);
                for (EntityLivingBase target : pult.field_70170_p.func_72872_a(EntityMob.class, aabb)) {
                    EntityPult cabbage = this.getPultBullet(pult);
                    cabbage.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    cabbage.shoot1(target);
                    this.field_70170_p.func_72838_d((Entity)cabbage);
                }
            }
        } else {
            System.out.println("wrong thrower!");
            return;
        }
        this.func_70106_y();
    }

    protected abstract EntityPult getPultBullet(EntityPultBase var1);

    protected void shoot1(EntityLivingBase target) {
        double dx = target.field_70165_t - this.field_70165_t;
        double dy = target.field_70163_u - this.field_70163_u;
        double dz = target.field_70161_v - this.field_70161_v;
        double dis = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.field_70159_w = dx / dis * 5.0;
        this.field_70181_x = dy / dis * 5.0;
        this.field_70179_y = dz / dis * 5.0;
    }

    protected void func_70184_a(RayTraceResult result) {
        Entity target = result.field_72308_g;
        if (this.checkCanAttack(target)) {
            this.performAttack(target);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            if (!this.checkLive(result)) {
                this.performSpiltDamage();
                this.func_70106_y();
            }
        } else if (!this.checkLive(result)) {
            this.spawnDeathParticle();
        }
    }

    protected void performSpiltDamage() {
    }

    protected void spawnDeathParticle() {
    }

    protected void performAttack(Entity target) {
        target.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this.func_85052_h()), this.getAttackDamage());
    }

    protected abstract float getAttackDamage();

    protected float func_70185_h() {
        if (this.getPultType() == Type.DOWN) {
            return 0.0f;
        }
        return 0.1f;
    }

    public Type getPultType() {
        return Type.values()[(Integer)this.field_70180_af.func_187225_a(PULT_TYPE)];
    }

    public void setPultType(Type type) {
        this.field_70180_af.func_187227_b(PULT_TYPE, (Object)type.ordinal());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("pult_type", this.getPultType().ordinal());
    }

    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setPultType(Type.values()[compund.func_74762_e("pult_type")]);
    }

    public static enum Type {
        NORMAL,
        EXPLODE,
        DOWN;

    }
}

