/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.bullets;

import com.hungteen.pvzmod.util.ConfigurationUtil;
import com.hungteen.pvzmod.util.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public abstract class PVZThrowable
extends EntityThrowable
implements IThrowableEntity {
    protected EntityLivingBase shooter;

    public PVZThrowable(World worldIn) {
        super(worldIn);
    }

    public PVZThrowable(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
        this.shooter = throwerIn;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa >= 200) {
            this.func_70106_y();
        }
    }

    protected boolean checkCanAttack(Entity target) {
        return EntityUtil.checkCanEntityAttack((Entity)this.func_85052_h(), target);
    }

    protected boolean checkLive(RayTraceResult result) {
        Entity target = result.field_72308_g;
        if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (!ConfigurationUtil.MainConfig.damageSettings.canBulletPassEntity) {
                return false;
            }
            return !EntityUtil.checkCanEntityAttack((Entity)this.func_85052_h(), target);
        }
        return false;
    }

    public void shoot(double dx, double dy, double dz) {
        EntityLivingBase target = null;
        if (this.func_85052_h() == null) {
            System.out.println("thrower error!");
            return;
        }
        target = ((EntityLiving)this.func_85052_h()).func_70638_az();
        if (target == null) {
            return;
        }
        double h = this.getThrowHeight(dy);
        double g = this.func_70185_h();
        double t1 = MathHelper.func_76133_a((double)(2.0 * h / g));
        double t2 = MathHelper.func_76133_a((double)(2.0 * (h - dy) / g));
        double dxz = MathHelper.func_76133_a((double)((dx += target.field_70159_w * (t1 + t2)) * dx + (dz += target.field_70179_y * (t1 + t2)) * dz));
        double vxz = dxz / (t1 + t2);
        double vy = g * t1;
        this.field_70159_w = vxz * dx / dxz;
        this.field_70181_x = vy;
        this.field_70179_y = vxz * dz / dxz;
    }

    public void setThrower(Entity entity) {
        this.shooter = (EntityLivingBase)entity;
    }

    public EntityLivingBase func_85052_h() {
        return this.shooter;
    }

    protected double getThrowHeight(double y) {
        return Math.floor(y) / 10.0 * 10.0 + 10.0;
    }
}

