/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.drops;

import com.hungteen.pvzmod.util.PlayerUtil;
import com.hungteen.pvzmod.util.SoundsHandler;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityCoin
extends EntityCreature
implements IEntityAdditionalSpawnData {
    protected int aliveTick;
    private int type;

    public EntityCoin(World worldIn) {
        super(worldIn);
        this.aliveTick = 0;
        Random random = new Random();
        this.type = random.nextInt(4);
        this.func_70105_a(0.3f, 0.3f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    public EntityCoin(World worldIn, int type) {
        super(worldIn);
        this.aliveTick = 0;
        this.type = type;
        this.func_70105_a(0.3f, 0.3f);
    }

    public EntityCoin(World worldIn, double x, double y, double z, int type) {
        super(worldIn);
        this.func_70107_b(x, y, z);
        this.aliveTick = 0;
        this.type = type;
    }

    public void func_70636_d() {
        ++this.aliveTick;
        if (this.aliveTick == 300) {
            this.func_70106_y();
        }
        super.func_70636_d();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("aliveTick", this.aliveTick);
        compound.func_74768_a("CoinType", this.type);
    }

    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.aliveTick = compund.func_74762_e("aliveTick");
        this.type = compund.func_74762_e("CoinType");
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            PlayerUtil.addPlayerMoney(player, this.getMoney());
            this.func_70106_y();
            if (this.getCoinType() == CoinType.JEWEL) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsHandler.GET_JEWEL, SoundCategory.NEUTRAL, 4.0f, 1.0f);
            } else {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsHandler.GET_COIN, SoundCategory.NEUTRAL, 4.0f, 1.0f);
            }
        }
    }

    public CoinType getCoinType() {
        return CoinType.values()[this.type];
    }

    public int getMoney() {
        if (this.getCoinType() == CoinType.COPPER) {
            return 1;
        }
        if (this.getCoinType() == CoinType.SILVER) {
            return 10;
        }
        if (this.getCoinType() == CoinType.GOLD) {
            return 100;
        }
        if (this.getCoinType() == CoinType.JEWEL) {
            return 1000;
        }
        return 1;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public boolean func_190530_aW() {
        return true;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return null;
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.aliveTick);
        buffer.writeInt(this.type);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.aliveTick = additionalData.readInt();
        this.type = additionalData.readInt();
    }

    public static enum CoinType {
        COPPER,
        SILVER,
        GOLD,
        JEWEL;

    }
}

