/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.base;

import com.hungteen.pvzmod.Main;
import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.entities.drops.EntitySun;
import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.particles.base.PVZParticleType;
import com.hungteen.pvzmod.registry.BlockRegister;
import com.hungteen.pvzmod.util.EntityUtil;
import com.hungteen.pvzmod.util.PlantsUtil;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.interfaces.IPlant;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class EntityPlantBase
extends EntityCreature
implements IPlant {
    protected int weakTime = 0;
    protected boolean isImmuneToWeak = false;
    private final int weakCD = 10;
    private final int weakDamage = 15;
    private static final DataParameter<Integer> SUPER_TIME = EntityDataManager.func_187226_a(EntityPlantBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PLANT_LVL = EntityDataManager.func_187226_a(EntityPlantBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> OWNER_NAME = EntityDataManager.func_187226_a(EntityPlantBase.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> IS_SUPER_OUT = EntityDataManager.func_187226_a(EntityPlantBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ATTACK_TIME = EntityDataManager.func_187226_a(EntityPlantBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GOLD_TIME = EntityDataManager.func_187226_a(EntityPlantBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(EntityPlantBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_CHARMED = EntityDataManager.func_187226_a(EntityPlantBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_GARDEN_PLANT = EntityDataManager.func_187226_a(EntityPlantBase.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityPlantBase(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUPER_TIME, (Object)0);
        this.field_70180_af.func_187214_a(PLANT_LVL, (Object)1);
        this.field_70180_af.func_187214_a(OWNER_NAME, (Object)"");
        this.field_70180_af.func_187214_a(IS_SUPER_OUT, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TIME, (Object)0);
        this.field_70180_af.func_187214_a(GOLD_TIME, (Object)2400);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
        this.field_70180_af.func_187214_a(IS_CHARMED, (Object)false);
        this.field_70180_af.func_187214_a(IS_GARDEN_PLANT, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getLife());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.getIsGardenPlant()) {
            return;
        }
        this.onNormalPlantUpdate();
    }

    public void onNormalPlantUpdate() {
        if (!this.field_70170_p.field_72995_K && !this.isImmuneToWeak) {
            if (this.checkWeak() && this.weakTime == 0) {
                this.weakTime = this.weakCD;
                PVZDamageSource pVZDamageSource = PVZDamageSource.causeWeakDamage((Entity)this, (Entity)this);
                this.getClass();
                this.func_70097_a((DamageSource)pVZDamageSource, 15.0f);
            }
            if (this.weakTime > 0) {
                --this.weakTime;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getSuperTime() > 0) {
                this.setSuperTime(this.getSuperTime() - 1);
            } else {
                this.setIsSuperOut(true);
            }
            if (this.getBoostTime() > 0) {
                this.setBoostTime(this.getBoostTime() - 1);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getGoldTime() > 0) {
            Block block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v)).func_177230_c();
            int amount = 0;
            if (block == BlockRegister.GOLDENTILE1) {
                this.setGoldTime(this.getGoldTime() - 1);
                amount = 25;
            } else if (block == BlockRegister.GOLDENTILE2) {
                this.setGoldTime(this.getGoldTime() - 2);
                amount = 35;
            } else if (block == BlockRegister.GOLDENTILE3) {
                this.setGoldTime(this.getGoldTime() - 3);
                amount = 50;
            }
            if (this.getGoldTime() <= 0) {
                this.setGoldTime(2400);
                EntitySun sun = new EntitySun(this.field_70170_p, this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v, amount);
                this.func_184185_a(SoundEvents.field_187604_bf, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.field_70170_p.func_72838_d((Entity)sun);
            }
        }
    }

    protected boolean checkWeak() {
        if (this.isImmuneToWeak) {
            return false;
        }
        Entity entity = this.func_184187_bx();
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)(this.field_70163_u - 1.0));
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        return !PlantsUtil.checkCanPlantLiveHere(this, this.getIsGardenPlant());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag2;
        if (!ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (source.func_76347_k() && this.func_70644_a(MobEffects.field_76426_n)) {
            return false;
        }
        float f = amount;
        if (!(source != DamageSource.field_82728_o && source != DamageSource.field_82729_p || this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b())) {
            this.func_184582_a(EntityEquipmentSlot.HEAD).func_77972_a((int)(amount * 4.0f + this.field_70146_Z.nextFloat() * amount * 2.0f), (EntityLivingBase)this);
            amount *= 0.75f;
        }
        boolean flag = false;
        this.field_70721_aZ = 1.5f;
        boolean flag1 = true;
        this.field_110153_bc = amount;
        this.func_70665_d(source, amount);
        this.field_70739_aP = 0.0f;
        Entity entity1 = source.func_76346_g();
        if (entity1 != null) {
            EntityTameable entitywolf;
            if (entity1 instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)entity1);
            }
            if (entity1 instanceof EntityPlayer) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (EntityPlayer)entity1;
            } else if (entity1 instanceof EntityTameable && (entitywolf = (EntityTameable)entity1).func_70909_n()) {
                this.field_70718_bc = 100;
                this.field_70717_bb = null;
            }
        }
        if (flag1) {
            if (flag) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)33);
            } else {
                byte b0 = source == DamageSource.field_76369_e ? (byte)36 : (source.func_76347_k() ? (byte)37 : 2);
                this.field_70170_p.func_72960_a((Entity)this, b0);
            }
            if (source != DamageSource.field_76369_e && (!flag || amount > 0.0f)) {
                this.func_70018_K();
            }
            if (entity1 != null) {
                double d1 = entity1.field_70165_t - this.field_70165_t;
                double d0 = entity1.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)this.field_70177_z);
                this.func_70653_a(entity1, 0.4f, d1, d0);
            } else {
                this.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            SoundEvent soundevent = this.func_184615_bR();
            if (flag1 && soundevent != null) {
                this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
            }
            this.func_70645_a(source);
        } else if (flag1) {
            this.func_184581_c(source);
        }
        boolean bl = flag2 = !flag || amount > 0.0f;
        if (entity1 instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192127_g.func_192220_a((EntityPlayerMP)entity1, (Entity)this, source, f, amount, flag);
        }
        return flag2;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("plant_weak_time", this.weakTime);
        compound.func_74768_a("plant_lvl", this.getPlantLvl());
        compound.func_74768_a("plant_super_time", this.getSuperTime());
        compound.func_74757_a("is_super_out", this.getIsSuperOut());
        compound.func_74768_a("plant_attack_time", this.getAttackTime());
        compound.func_74768_a("plant_gold_time", this.getGoldTime());
        if (!this.getOwnerName().equals("")) {
            compound.func_74778_a("plant_owner_name", this.getOwnerName());
        }
        compound.func_74768_a("plant_boost_time", this.getBoostTime());
        compound.func_74757_a("is_plant_charmed", this.getIsCharmed());
        compound.func_74757_a("is_garden_plant", this.getIsGardenPlant());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.weakTime = compound.func_74762_e("plant_weak_time");
        this.setPlantLvl(compound.func_74762_e("plant_lvl"));
        this.setSuperTime(compound.func_74762_e("plant_super_time"));
        this.setIsSuperOut(compound.func_74767_n("is_plant_out"));
        this.setAttackTime(compound.func_74762_e("plant_attack_time"));
        this.setGoldTime(compound.func_74762_e("plant_gold_time"));
        if (compound.func_74764_b("ownerName")) {
            this.setOwnerName(compound.func_74779_i("plant_owner_name"));
        } else {
            this.setOwnerName("");
        }
        this.setBoostTime(compound.func_74762_e("plant_boost_time"));
        this.setIsCharmed(compound.func_74767_n("is_plant_charmed"));
        this.setIsGardenPlant(compound.func_74767_n("is_garden_plant"));
    }

    public int getBoostTime() {
        return (Integer)this.field_70180_af.func_187225_a(BOOST_TIME);
    }

    public void setBoostTime(int time) {
        this.field_70180_af.func_187227_b(BOOST_TIME, (Object)time);
    }

    public boolean getIsCharmed() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CHARMED);
    }

    public void setIsCharmed(boolean is) {
        this.field_70180_af.func_187227_b(IS_CHARMED, (Object)is);
    }

    public boolean getIsGardenPlant() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_GARDEN_PLANT);
    }

    public void setIsGardenPlant(boolean is) {
        this.field_70180_af.func_187227_b(IS_GARDEN_PLANT, (Object)is);
    }

    public int getGoldTime() {
        return (Integer)this.field_70180_af.func_187225_a(GOLD_TIME);
    }

    public void setGoldTime(int cd) {
        this.field_70180_af.func_187227_b(GOLD_TIME, (Object)cd);
    }

    public int getAttackTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TIME);
    }

    public void setAttackTime(int cd) {
        this.field_70180_af.func_187227_b(ATTACK_TIME, (Object)cd);
    }

    public boolean getIsSuperOut() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SUPER_OUT);
    }

    public void setIsSuperOut(boolean is) {
        this.field_70180_af.func_187227_b(IS_SUPER_OUT, (Object)is);
    }

    public void setPlantLvl(int lvl) {
        this.field_70180_af.func_187227_b(PLANT_LVL, (Object)lvl);
    }

    public int getPlantLvl() {
        return (Integer)this.field_70180_af.func_187225_a(PLANT_LVL);
    }

    @Nullable
    public String getOwnerName() {
        return (String)this.field_70180_af.func_187225_a(OWNER_NAME);
    }

    public void setOwnerName(String name) {
        this.field_70180_af.func_187227_b(OWNER_NAME, (Object)name);
    }

    public void setSuperTime(int time) {
        this.field_70180_af.func_187227_b(SUPER_TIME, (Object)time);
    }

    public int getSuperTime() {
        return (Integer)this.field_70180_af.func_187225_a(SUPER_TIME);
    }

    public void updateAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getLife());
        this.func_70691_i(this.func_110138_aP());
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70108_f(Entity entityIn) {
        if (!(this.func_184223_x(entityIn) || entityIn.field_70145_X || this.field_70145_X)) {
            double d0 = entityIn.field_70165_t - this.field_70165_t;
            double d1 = entityIn.field_70161_v - this.field_70161_v;
            double d2 = MathHelper.func_76132_a((double)d0, (double)d1);
            if (d2 >= (double)0.01f) {
                d2 = MathHelper.func_76133_a((double)d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                d0 *= (double)(1.0f - this.field_70144_Y);
                d1 *= (double)(1.0f - this.field_70144_Y);
                if (!this.func_184207_aI() && !(entityIn instanceof EntityZombieBase)) {
                    this.func_70024_g(-d0, 0.0, -d1);
                }
                if (!entityIn.func_184207_aI()) {
                    entityIn.func_70024_g(d0, 0.0, d1);
                }
            } else {
                this.func_70024_g(this.func_70681_au().nextFloat() - 0.5f, 0.0, this.func_70681_au().nextFloat() - 0.5f);
                entityIn.func_70024_g((double)(this.func_70681_au().nextFloat() - 0.5f), 0.0, (double)(this.func_70681_au().nextFloat() - 0.5f));
            }
        }
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ());
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_180263_c("maxEntityCramming");
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (((Entity)list.get(k)).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (!EntityUtil.checkShouldApplyCollision((Entity)this, entity)) continue;
                this.func_82167_n(entity);
            }
        }
    }

    public void startSuperMode() {
        this.setSuperTime(this.getSuperTimeLength());
        this.setIsSuperOut(false);
        for (int i = 1; i <= 10; ++i) {
            Main.proxy.spawnParticle(PVZParticleType.SUPER_PLANT_FOOD, this.field_70165_t, this.field_70163_u, this.field_70161_v, (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f, 0.15f, (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f);
        }
    }

    public boolean isPlantInSuperMode() {
        return this.getSuperTime() > 0;
    }

    public boolean canStartSuperMode() {
        return !this.isPlantInSuperMode();
    }

    public boolean isPlantInBoost() {
        return this.getBoostTime() > 0;
    }

    @Override
    public int getCoolDownTime() {
        return PlantsUtil.getPlantCoolDownTime(this.getPlantEnumName(), this.getPlantLvl());
    }

    @Override
    public int getSunCost() {
        return PlantsUtil.getPlantSunCost(this.getPlantEnumName());
    }

    @Override
    public float getLife() {
        return PlantsUtil.getPlantMaxHealth(this.getPlantEnumName(), this.getPlantLvl());
    }

    public float getAttackDamage() {
        return 0.0f;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsHandler.PLANT_HURT;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return true;
    }
}

