/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.base;

import com.hungteen.pvzmod.entities.ai.attack.PVZAIPultAttack;
import com.hungteen.pvzmod.entities.ai.target.PVZAIPlantGlobalTarget;
import com.hungteen.pvzmod.entities.bullets.EntityPult;
import com.hungteen.pvzmod.entities.plants.base.EntityPlantBase;
import com.hungteen.pvzmod.entities.plants.common.EntityCabbagePult;
import com.hungteen.pvzmod.util.interfaces.IPult;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityPultBase
extends EntityPlantBase
implements IPult {
    private static final DataParameter<Boolean> IS_ATTACKED = EntityDataManager.func_187226_a(EntityCabbagePult.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_OUT = EntityDataManager.func_187226_a(EntityCabbagePult.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CAN_ATTACK_NOW = EntityDataManager.func_187226_a(EntityCabbagePult.class, (DataSerializer)DataSerializers.field_187198_h);
    private final double LENTH = 0.5;

    public EntityPultBase(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_ATTACKED, (Object)false);
        this.field_70180_af.func_187214_a(IS_OUT, (Object)false);
        this.field_70180_af.func_187214_a(CAN_ATTACK_NOW, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new PVZAIPultAttack(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 1.5f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new PVZAIPlantGlobalTarget(this, 50.0f, 50.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isAttacked", this.getIsAttacked());
        compound.func_74757_a("isOut", this.getIsOut());
        compound.func_74757_a("canAttackNow", this.getCanAttackNow());
    }

    @Override
    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setIsAttacked(compund.func_74767_n("isAttacked"));
        this.setIsOut(compund.func_74767_n("isOut"));
        this.setCanAttackNow(compund.func_74767_n("canAttackNow"));
    }

    @Override
    public void onNormalPlantUpdate() {
        super.onNormalPlantUpdate();
        if (this.getIsAttacked()) {
            this.setAttackTime(0);
            this.setCanAttackNow(true);
            this.setIsAttacked(false);
        }
        if (this.getCanAttackNow()) {
            if (this.getAttackTime() >= 20) {
                this.setCanAttackNow(false);
                this.setAttackTime(0);
                this.setIsOut(false);
                if (!this.field_70170_p.field_72995_K) {
                    this.changeBullet();
                }
            } else if (this.getAttackTime() == 8) {
                this.setIsOut(true);
                if (!this.field_70170_p.field_72995_K) {
                    this.throwBullet();
                }
            }
        }
        this.setAttackTime(this.getAttackTime() + 1);
    }

    protected void changeBullet() {
    }

    private void throwBullet() {
        if (this.func_70638_az() == null) {
            return;
        }
        EntityLivingBase target = this.func_70638_az();
        double dx = target.field_70165_t - this.field_70165_t;
        double dz = target.field_70161_v - this.field_70161_v;
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double tmp = this.LENTH / dis;
        double deltaX = tmp * dx;
        double deltaZ = tmp * dz;
        EntityPult cabbage = this.getBullet();
        cabbage.func_70107_b(this.field_70165_t - deltaX, this.field_70163_u + (double)1.7f, this.field_70161_v - deltaZ);
        cabbage.shoot(target.field_70165_t - cabbage.field_70165_t, target.field_70163_u - cabbage.field_70163_u + 0.5, target.field_70161_v - cabbage.field_70161_v);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)cabbage);
    }

    protected abstract EntityPult getBullet();

    @Override
    public void startPultAttack() {
        this.setIsAttacked(true);
    }

    public void setIsAttacked(boolean isAttacked) {
        this.field_70180_af.func_187227_b(IS_ATTACKED, (Object)isAttacked);
    }

    public boolean getIsAttacked() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ATTACKED);
    }

    public void setIsOut(boolean isOut) {
        this.field_70180_af.func_187227_b(IS_OUT, (Object)isOut);
    }

    public boolean getIsOut() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_OUT);
    }

    public void setCanAttackNow(boolean canAttackNow) {
        this.field_70180_af.func_187227_b(CAN_ATTACK_NOW, (Object)canAttackNow);
    }

    public boolean getCanAttackNow() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_ATTACK_NOW);
    }

    public int getRange() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return 15;
        }
        if (lvl <= 13) {
            return 20;
        }
        if (lvl <= 20) {
            return 30;
        }
        return 15;
    }

    @Override
    public int getPultSpeed() {
        return 60;
    }

    @Override
    public int getSuperTimeLength() {
        return 100;
    }
}

