/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.common;

import com.hungteen.pvzmod.entities.bullets.EntityCabbage;
import com.hungteen.pvzmod.entities.bullets.EntityPult;
import com.hungteen.pvzmod.entities.plants.base.EntityPultBase;
import com.hungteen.pvzmod.util.enums.Plants;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class EntityCabbagePult
extends EntityPultBase {
    public EntityCabbagePult(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.75f, 0.65f);
    }

    @Override
    protected EntityPult getBullet() {
        EntityPult.Type type = EntityPult.Type.NORMAL;
        if (this.isPlantInSuperMode() && !this.getIsSuperOut()) {
            type = EntityPult.Type.EXPLODE;
            this.setIsSuperOut(true);
        }
        return new EntityCabbage(this.field_70170_p, (EntityLivingBase)this, type);
    }

    @Override
    public int getPultSpeed() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            return 60 - 5 * now;
        }
        return 60;
    }

    @Override
    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return (float)lvl * 0.5f + 3.5f;
        }
        if (lvl <= 20) {
            return 14.0f;
        }
        return 4.0f;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CABBAGE_PULT;
    }
}

