/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.common;

import com.hungteen.pvzmod.entities.bullets.EntityButter;
import com.hungteen.pvzmod.entities.bullets.EntityKernel;
import com.hungteen.pvzmod.entities.bullets.EntityPult;
import com.hungteen.pvzmod.entities.plants.base.EntityPultBase;
import com.hungteen.pvzmod.entities.plants.common.EntityCabbagePult;
import com.hungteen.pvzmod.registry.PotionRegister;
import com.hungteen.pvzmod.util.enums.Plants;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class EntityKernelPult
extends EntityPultBase {
    private static final DataParameter<Boolean> IS_BUTTER_NOW = EntityDataManager.func_187226_a(EntityCabbagePult.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityKernelPult(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BUTTER_NOW, (Object)(this.func_70681_au().nextInt(2) == 1 ? 1 : 0));
    }

    @Override
    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setIsButterNow(compund.func_74767_n("is_butter_now"));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("is_butter_now", this.getIsButterNow());
    }

    @Override
    protected EntityPult getBullet() {
        if (this.isPlantInSuperMode() && !this.getIsSuperOut()) {
            this.setIsSuperOut(true);
            return new EntityButter(this.field_70170_p, (EntityLivingBase)this, EntityPult.Type.EXPLODE);
        }
        if (this.getIsButterNow()) {
            return new EntityButter(this.field_70170_p, (EntityLivingBase)this, EntityPult.Type.NORMAL);
        }
        return new EntityKernel(this.field_70170_p, this, EntityPult.Type.NORMAL);
    }

    @Override
    protected void changeBullet() {
        if (this.func_70681_au().nextInt(5) == 1) {
            this.setIsButterNow(true);
        } else {
            this.setIsButterNow(false);
        }
    }

    @Override
    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 2;
            return 3 + now;
        }
        return 3.0f;
    }

    public PotionEffect getButterEffect() {
        int lvl = this.getPlantLvl();
        int time = 0;
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            time = 8 + 2 * now;
        }
        return new PotionEffect(PotionRegister.BUTTER_EFFECT, time * 20, 1, false, false);
    }

    public void setIsButterNow(boolean is) {
        this.field_70180_af.func_187227_b(IS_BUTTER_NOW, (Object)is);
    }

    public boolean getIsButterNow() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BUTTER_NOW);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.KERNEL_PULT;
    }
}

