/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.explosion;

import com.hungteen.pvzmod.Main;
import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.entities.bullets.EntityPotato;
import com.hungteen.pvzmod.entities.plants.base.EntityNearPlantBase;
import com.hungteen.pvzmod.particles.base.PVZParticleType;
import com.hungteen.pvzmod.util.EntityUtil;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.enums.Plants;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityPotatoMine
extends EntityNearPlantBase {
    private static final DataParameter<Integer> MINE_STATE = EntityDataManager.func_187226_a(EntityPotatoMine.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean sign_state = false;

    public EntityPotatoMine(World worldIn) {
        super(worldIn);
        this.range = 1.0f;
        this.func_70105_a(0.6f, 0.4f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MINE_STATE, (Object)MineState.PRE.ordinal());
    }

    @Override
    public void onNormalPlantUpdate() {
        if (this.getAttackTime() % this.getSignChangeTime() == 0) {
            boolean bl = this.sign_state = !this.sign_state;
        }
        if (this.isPlantInSuperMode()) {
            if (this.getMineState() == MineState.PRE) {
                this.outDirt();
            }
            this.performShoot();
        }
        this.setAttackTime(this.getAttackTime() + 1);
        if (this.getAttackTime() >= this.getReadyTime() && this.getMineState() == MineState.PRE) {
            this.outDirt();
        }
        super.onNormalPlantUpdate();
    }

    @Override
    protected void performAttack() {
        if (this.getMineState() == MineState.READY) {
            if (!this.field_70170_p.field_72995_K) {
                AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - (double)this.range, this.field_70163_u - (double)this.range, this.field_70161_v - (double)this.range, this.field_70165_t + (double)this.range, this.field_70163_u + (double)this.range, this.field_70161_v + (double)this.range);
                for (EntityLivingBase target : EntityUtil.getEntityAttackableTarget((EntityLivingBase)this, aabb)) {
                    target.func_70097_a((DamageSource)PVZDamageSource.causeExplosionDamage((Entity)this, (Entity)this), this.getAttackDamage());
                }
                this.func_184185_a(SoundsHandler.POTATOMINE_EXPLODE, 1.0f, 1.0f);
            }
            for (int i = 1; i <= 5; ++i) {
                Main.proxy.spawnParticle(PVZParticleType.DIRT_BURSTOUT, this.field_70165_t, this.field_70163_u, this.field_70161_v, ((double)this.field_70146_Z.nextFloat() - 0.5) / 4.0, 0.4, ((double)this.field_70146_Z.nextFloat() - 0.5) / 4.0);
                Main.proxy.spawnParticle(PVZParticleType.POTATO_BOMB, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                Main.proxy.spawnParticle(PVZParticleType.DIRT_BURSTOUT, this.field_70165_t, this.field_70163_u, this.field_70161_v, ((double)this.field_70146_Z.nextFloat() - 0.5) / 4.0, 0.4, ((double)this.field_70146_Z.nextFloat() - 0.5) / 4.0);
            }
            this.func_70106_y();
        }
    }

    private void outDirt() {
        if (!this.field_70170_p.field_72995_K) {
            this.setMineState(MineState.READY);
        }
        for (int i = 1; i <= 5; ++i) {
            Random rand = new Random();
            Main.proxy.spawnParticle(PVZParticleType.DIRT_BURSTOUT, this.field_70165_t + 0.5, this.field_70163_u, this.field_70161_v + 0.5, ((double)rand.nextFloat() - 0.5) / 10.0, 0.05, ((double)rand.nextFloat() - 0.5) / 10.0);
            Main.proxy.spawnParticle(PVZParticleType.DIRT_BURSTOUT, this.field_70165_t + 0.5, this.field_70163_u, this.field_70161_v - 0.5, ((double)rand.nextFloat() - 0.5) / 10.0, 0.05, ((double)rand.nextFloat() - 0.5) / 10.0);
            Main.proxy.spawnParticle(PVZParticleType.DIRT_BURSTOUT, this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v + 0.5, ((double)rand.nextFloat() - 0.5) / 10.0, 0.05, ((double)rand.nextFloat() - 0.5) / 10.0);
            Main.proxy.spawnParticle(PVZParticleType.DIRT_BURSTOUT, this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, ((double)rand.nextFloat() - 0.5) / 10.0, 0.05, ((double)rand.nextFloat() - 0.5) / 10.0);
        }
    }

    private void performShoot() {
        int lvl = this.getPlantLvl();
        if (lvl >= 1) {
            this.shootPotato(0.4f);
        }
        if (lvl >= 7) {
            this.shootPotato(0.7f);
        }
        if (lvl >= 14) {
            this.shootPotato(1.1f);
        }
    }

    private void shootPotato(float r) {
        if (!this.field_70170_p.field_72995_K) {
            EntityPotato potato = new EntityPotato(this.field_70170_p, (EntityLivingBase)this);
            potato.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
            float dx = (this.func_70681_au().nextFloat() - 0.5f) * r;
            float dy = 1.0f;
            float dz = (this.func_70681_au().nextFloat() - 0.5f) * r;
            potato.shoot(dx, dy, dz);
            this.field_70170_p.func_72838_d((Entity)potato);
        }
    }

    protected int getSignChangeTime() {
        if (this.getMineState() == MineState.PRE) {
            return 20;
        }
        return 10;
    }

    private int getReadyTime() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            return 240 - 20 * now;
        }
        return 240;
    }

    @Override
    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl >= 1 && lvl <= 6) {
            return 150.0f;
        }
        if (lvl >= 7 && lvl <= 13) {
            return 180.0f;
        }
        if (lvl <= 20) {
            return 225.0f;
        }
        return 150.0f;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("mine_state", this.getMineState().ordinal());
        compound.func_74757_a("sign_state", this.sign_state);
    }

    @Override
    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setMineState(MineState.values()[compund.func_74762_e("mine_state")]);
        this.sign_state = compund.func_74767_n("sign_state");
    }

    public void setMineState(MineState state) {
        this.field_70180_af.func_187227_b(MINE_STATE, (Object)state.ordinal());
    }

    public MineState getMineState() {
        return MineState.values()[(Integer)this.field_70180_af.func_187225_a(MINE_STATE)];
    }

    public boolean getSignState() {
        return this.sign_state;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.POTATO_MINE;
    }

    public static enum MineState {
        PRE,
        READY;

    }
}

