/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.fight;

import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.damage.PVZDamageType;
import com.hungteen.pvzmod.entities.plants.base.EntityPlantBase;
import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.entities.zombies.poolday.EntityZomboni;
import com.hungteen.pvzmod.util.EntityUtil;
import com.hungteen.pvzmod.util.enums.Plants;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntitySpikeRock
extends EntityPlantBase {
    private static final DataParameter<Integer> SPIKE_NUM = EntityDataManager.func_187226_a(EntitySpikeRock.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySpikeRock(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.3f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPIKE_NUM, (Object)0);
    }

    @Override
    public void onNormalPlantUpdate() {
        super.onNormalPlantUpdate();
        if (!this.field_70170_p.field_72995_K && this.isPlantInSuperMode()) {
            float r = this.getSuperRange();
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - (double)r, this.field_70163_u, this.field_70161_v - (double)r, this.field_70165_t + (double)r, this.field_70163_u + 0.5, this.field_70161_v + (double)r);
            for (Entity entity : EntityUtil.getEntityAttackableTarget((EntityLivingBase)this, aabb)) {
                entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
    }

    public float getSuperRange() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return 7.5f;
        }
        if (lvl <= 13) {
            return 10.0f;
        }
        if (lvl <= 20) {
            return 15.0f;
        }
        return 7.5f;
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        if (!(this.func_184223_x(entityIn) || entityIn.field_70145_X || this.field_70145_X)) {
            double d0 = entityIn.field_70165_t - this.field_70165_t;
            double d1 = entityIn.field_70161_v - this.field_70161_v;
            double d2 = MathHelper.func_76132_a((double)d0, (double)d1);
            if (d2 >= (double)0.01f) {
                d2 = MathHelper.func_76133_a((double)d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                d0 *= (double)(1.0f - this.field_70144_Y);
                d1 *= (double)(1.0f - this.field_70144_Y);
                if (!this.func_184207_aI() && !(entityIn instanceof EntityZombieBase)) {
                    this.func_70024_g(-d0, 0.0, -d1);
                }
                if (!entityIn.func_184207_aI()) {
                    entityIn.func_70024_g(d0, 0.0, d1);
                }
            } else {
                this.func_70024_g(this.func_70681_au().nextFloat() - 0.5f, 0.0, this.func_70681_au().nextFloat() - 0.5f);
                entityIn.func_70024_g((double)(this.func_70681_au().nextFloat() - 0.5f), 0.0, (double)(this.func_70681_au().nextFloat() - 0.5f));
            }
        }
    }

    @Override
    protected void func_85033_bc() {
        List list = this.field_70170_p.func_72872_a(EntityLiving.class, this.func_174813_aQ());
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_180263_c("maxEntityCramming");
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (((Entity)list.get(k)).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (entity instanceof EntityPlantBase) {
                    this.func_82167_n(entity);
                    continue;
                }
                this.spikeNormalAttack(entity);
            }
        }
    }

    private void spikeNormalAttack(Entity entity) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getAttackTime() < this.getAttackCD()) {
            this.setAttackTime(this.getAttackTime() + 1);
            return;
        }
        this.setAttackTime(0);
        if (EntityUtil.checkCanEntityAttack((Entity)this, entity)) {
            if (entity instanceof EntityZomboni && ((EntityZomboni)entity).func_110143_aJ() > 0.0f) {
                entity.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this), ((EntityZomboni)entity).func_110143_aJ());
                if (this.getSpikeNum() < this.getMaxSpikeNum()) {
                    this.setSpikeNum(this.getSpikeNum() + 1);
                } else {
                    this.func_70106_y();
                }
            } else {
                entity.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this), this.getAttackDamage());
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (source instanceof PVZDamageSource && ((PVZDamageSource)source).getPVZDamageType() == PVZDamageType.DEAD) {
            if (this.getSpikeNum() < this.getMaxSpikeNum()) {
                this.setSpikeNum(this.getSpikeNum() + 1);
                return true;
            }
            this.func_70106_y();
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    public int getMaxSpikeNum() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return 3;
        }
        if (lvl <= 13) {
            return 6;
        }
        if (lvl <= 20) {
            return 9;
        }
        return 3;
    }

    public int getAttackCD() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 5;
            return 10 - now;
        }
        return 10;
    }

    @Override
    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            return 4 + 2 * now;
        }
        return 4.0f;
    }

    public int getSpikeNum() {
        return (Integer)this.field_70180_af.func_187225_a(SPIKE_NUM);
    }

    public void setSpikeNum(int num) {
        this.field_70180_af.func_187227_b(SPIKE_NUM, (Object)num);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSpikeNum(compound.func_74762_e("spike_num"));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("spike_num", this.getSpikeNum());
    }

    @Override
    public int getSuperTimeLength() {
        return 2;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SPIKE_ROCK;
    }
}

