/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.fight;

import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.damage.PVZDamageType;
import com.hungteen.pvzmod.entities.ai.target.PVZAIPlantGlobalTarget;
import com.hungteen.pvzmod.entities.plants.base.EntityPlantBase;
import com.hungteen.pvzmod.util.EntityUtil;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.enums.Plants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntitySquash
extends EntityPlantBase {
    private static final DataParameter<Integer> EXTRA_CHANCE = EntityDataManager.func_187226_a(EntitySquash.class, (DataSerializer)DataSerializers.field_187192_b);
    private final float range = 3.0f;

    public EntitySquash(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EXTRA_CHANCE, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(10, (EntityAIBase)new PVZAIPlantGlobalTarget(this, 2.0f, 3.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(3.0);
    }

    @Override
    public void onNormalPlantUpdate() {
        EntityLivingBase target;
        super.onNormalPlantUpdate();
        if (this.isPlantInSuperMode()) {
            this.setExtraChance(this.getSuperChance());
        }
        if ((target = this.func_70638_az()) != null && this.func_70068_e((Entity)target) > EntityUtil.getAttackRange((Entity)this, (Entity)target, 3.0)) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAttackTime() == 1) {
                if (EntityUtil.isOnGround((Entity)this)) {
                    this.func_184185_a(SoundsHandler.GROUND_SHAKE, 4.0f, 1.0f);
                    this.dealDamage();
                    if (this.getExtraChance() > 0) {
                        this.setExtraChance(this.getExtraChance() - 1);
                    } else if (this.func_70681_au().nextInt(100) >= this.getDeathChance()) {
                        this.func_70106_y();
                    }
                    this.setAttackTime(0);
                }
            } else if (target != null && EntityUtil.checkCanEntityAttack((Entity)this, (Entity)target)) {
                this.func_184185_a(SoundsHandler.SQUASH_HMM, 4.0f, 1.0f);
                this.smash((Entity)target);
            }
        }
    }

    protected void smash(Entity target) {
        int tick = 10;
        double x = target.field_70165_t + target.field_70159_w * (double)tick;
        double y = target.field_70163_u + target.field_70181_x * (double)tick;
        double z = target.field_70161_v + target.field_70179_y * (double)tick;
        this.func_70107_b(x, y + (double)target.func_70047_e() + 3.0, z);
        this.field_70181_x = -0.15;
        this.setAttackTime(1);
    }

    protected void dealDamage() {
        this.setAttackTime(0);
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5);
        for (Entity entity : EntityUtil.getEntityAttackableTarget((EntityLivingBase)this, aabb)) {
            entity.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this), this.getAttackDamage());
        }
    }

    public int getExtraChance() {
        return (Integer)this.field_70180_af.func_187225_a(EXTRA_CHANCE);
    }

    public void setExtraChance(int chance) {
        this.field_70180_af.func_187227_b(EXTRA_CHANCE, (Object)chance);
    }

    protected int getSuperChance() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return 2;
        }
        if (lvl <= 13) {
            return 3;
        }
        if (lvl <= 20) {
            return 4;
        }
        return 2;
    }

    public boolean func_180431_b(DamageSource source) {
        if (source instanceof PVZDamageSource) {
            if (((PVZDamageSource)source).getPVZDamageType() == PVZDamageType.EAT) {
                return true;
            }
            if (((PVZDamageSource)source).getPVZDamageType() == PVZDamageType.DEAD) {
                return true;
            }
        }
        return false;
    }

    @Override
    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 18) {
            int now = (lvl - 1) / 2;
            return 10 * now + 120;
        }
        if (lvl <= 20) {
            return 225.0f;
        }
        return 130.0f;
    }

    protected int getDeathChance() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            return 10 + now * 10 - 1;
        }
        return 9;
    }

    @Override
    public int getSuperTimeLength() {
        return 2;
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setExtraChance(compound.func_74762_e("extra_chance"));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("extra_zombie", this.getExtraChance());
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SQUASH;
    }
}

