/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.ice;

import com.hungteen.pvzmod.Main;
import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.damage.PVZDamageType;
import com.hungteen.pvzmod.entities.plants.base.EntityShroomBase;
import com.hungteen.pvzmod.particles.base.PVZParticleType;
import com.hungteen.pvzmod.registry.PotionRegister;
import com.hungteen.pvzmod.util.EntityUtil;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.enums.Plants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityIceShroom
extends EntityShroomBase {
    public EntityIceShroom(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.75f, 1.2f);
    }

    @Override
    public void onNormalPlantUpdate() {
        super.onNormalPlantUpdate();
        if (!this.getIsSleeping()) {
            this.setAttackTime(this.getAttackTime() + 1);
            if (this.getAttackTime() >= this.getReadyTime()) {
                this.startBoom();
                this.func_70106_y();
                this.setAttackTime(0);
            }
        } else {
            this.setAttackTime(0);
        }
    }

    private void startBoom() {
        if (!this.field_70170_p.field_72995_K) {
            float len = this.getAttackLen();
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t + (double)len, this.field_70163_u + 30.0, this.field_70161_v + (double)len, this.field_70165_t - (double)len, this.field_70163_u - 5.0, this.field_70161_v - (double)len);
            for (Entity entity : EntityUtil.getEntityAttackableTarget((EntityLivingBase)this, aabb)) {
                entity.func_70097_a((DamageSource)PVZDamageSource.causeIceDamage((Entity)this, (Entity)this), this.getAttackDamage());
            }
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsHandler.FROZEN_PEA, SoundCategory.VOICE, 4.0f, 1.0f);
        }
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        for (int i = 1; i <= 15; ++i) {
            Main.proxy.spawnParticle(PVZParticleType.SNOW, this.field_70165_t, this.field_70163_u, this.field_70161_v, (this.func_70681_au().nextFloat() - 0.5f) / 4.0f, this.func_70681_au().nextFloat() / 5.0f, (this.func_70681_au().nextFloat() - 0.5f) / 4.0f);
        }
    }

    private int getAttackLen() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return 10;
        }
        if (lvl <= 13) {
            return 15;
        }
        if (lvl <= 20) {
            return 20;
        }
        return 10;
    }

    private int getReadyTime() {
        return 30;
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.getIsSleeping()) {
            return false;
        }
        return !(source instanceof PVZDamageSource) || ((PVZDamageSource)source).getPVZDamageType() != PVZDamageType.WEAK;
    }

    public PotionEffect getFrozenPotionEffect() {
        int time = 60;
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            time = 60 + 20 * now;
        }
        return new PotionEffect(PotionRegister.FROZEN_EFFECT, time, 1, false, false);
    }

    public PotionEffect getColdPotionEffect() {
        int time = 100;
        int lvl = this.getPlantLvl();
        if (lvl <= 18) {
            int now = (lvl - 1) / 2;
            time = 40 + 10 * now + 80;
        } else if (lvl <= 20) {
            time = 360;
        }
        return new PotionEffect(PotionRegister.COLD_EFFECT, time, 2, false, false);
    }

    @Override
    public boolean canStartSuperMode() {
        return false;
    }

    @Override
    public int getSuperTimeLength() {
        return 0;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.ICE_SHROOM;
    }
}

