/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.ice;

import com.hungteen.pvzmod.Main;
import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.entities.plants.base.EntityNearPlantBase;
import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.particles.base.PVZParticleType;
import com.hungteen.pvzmod.registry.PotionRegister;
import com.hungteen.pvzmod.util.enums.Plants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityIcebergLettuce
extends EntityNearPlantBase {
    public EntityIcebergLettuce(World worldIn) {
        super(worldIn);
        this.range = 1.5f;
        this.func_70105_a(0.5f, 0.5f);
    }

    @Override
    public void onNormalPlantUpdate() {
        super.onNormalPlantUpdate();
        if (this.isPlantInSuperMode()) {
            this.frozeAll();
        }
    }

    @Override
    protected void performAttack() {
        EntityLivingBase target = this.func_70638_az();
        if (target != null) {
            if (!this.field_70170_p.field_72995_K) {
                target.func_70097_a((DamageSource)PVZDamageSource.causeIceDamage((Entity)this, (Entity)this), 0.01f);
                this.func_70106_y();
            }
            for (int i = 1; i <= 5; ++i) {
                Main.proxy.spawnParticle(PVZParticleType.SNOW, this.field_70165_t, this.field_70163_u, this.field_70161_v, (this.func_70681_au().nextFloat() - 0.5f) / 4.0f, this.func_70681_au().nextFloat() / 5.0f, (this.func_70681_au().nextFloat() - 0.5f) / 4.0f);
            }
        }
    }

    private PotionEffect getSuperEffect1() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return new PotionEffect(PotionRegister.FROZEN_EFFECT, 200, 1);
        }
        if (lvl <= 13) {
            return new PotionEffect(PotionRegister.FROZEN_EFFECT, 240, 1);
        }
        if (lvl <= 20) {
            return new PotionEffect(PotionRegister.FROZEN_EFFECT, 300, 1);
        }
        return new PotionEffect(PotionRegister.FROZEN_EFFECT, 200, 1);
    }

    private PotionEffect getSuperEffect2() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return new PotionEffect(PotionRegister.COLD_EFFECT, 400, 4);
        }
        if (lvl <= 13) {
            return new PotionEffect(PotionRegister.COLD_EFFECT, 480, 4);
        }
        if (lvl <= 20) {
            return new PotionEffect(PotionRegister.COLD_EFFECT, 600, 4);
        }
        return new PotionEffect(PotionRegister.COLD_EFFECT, 400, 4);
    }

    private void frozeAll() {
        if (!this.field_70170_p.field_72995_K) {
            int r = this.getR();
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - (double)r, this.field_70163_u - 10.0, this.field_70161_v - (double)r, this.field_70165_t + (double)r, this.field_70163_u + 20.0, this.field_70161_v + (double)r);
            for (EntityLivingBase target : this.field_70170_p.func_72872_a(EntityMob.class, aabb)) {
                if (!(target instanceof EntityZombieBase) || ((EntityZombieBase)target).getIsCharmed()) continue;
                target.func_70690_d(this.getSuperEffect1());
                target.func_70690_d(this.getSuperEffect2());
            }
        }
    }

    public int getR() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return 10;
        }
        if (lvl <= 13) {
            return 15;
        }
        if (lvl <= 20) {
            return 20;
        }
        return 10;
    }

    public PotionEffect getFrozenEffect() {
        int lvl = this.getPlantLvl();
        int time = 0;
        if (lvl <= 19) {
            time = 90 + lvl * 10;
        } else if (lvl <= 20) {
            time = 300;
        }
        return new PotionEffect(PotionRegister.FROZEN_EFFECT, time, 1, false, false);
    }

    public PotionEffect getColdEffect() {
        int lvl = this.getPlantLvl();
        int time = 0;
        if (lvl <= 19) {
            time = 90 + lvl * 10;
        } else if (lvl <= 20) {
            time = 300;
        }
        if (lvl >= 7) {
            time += (lvl - 6) * 20;
        }
        return new PotionEffect(PotionRegister.COLD_EFFECT, time, 3, false, false);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.ICEBERG_LETTUCE;
    }
}

