/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.magic;

import com.hungteen.pvzmod.entities.ai.EntityAIPlantAttackRanged;
import com.hungteen.pvzmod.entities.ai.EntityAISuperPeaShooter;
import com.hungteen.pvzmod.entities.ai.target.PVZAIPlantGlobalTarget;
import com.hungteen.pvzmod.entities.bullets.EntityThorn;
import com.hungteen.pvzmod.entities.plants.base.EntityPlantBase;
import com.hungteen.pvzmod.registry.BlockRegister;
import com.hungteen.pvzmod.util.enums.Plants;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityCatTail
extends EntityPlantBase
implements IRangedAttackMob {
    public EntityCatTail(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.7f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIPlantAttackRanged(this, 0.0, this.getShootSpeed(), 50.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAISuperPeaShooter(this, 0.0, 2, 40.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 1.5f));
        this.field_70715_bh.func_75776_a(10, (EntityAIBase)new PVZAIPlantGlobalTarget(this, 30.0f, 50.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    @Override
    public void onNormalPlantUpdate() {
        super.onNormalPlantUpdate();
        if (this.getAttackTime() > 0 && !this.field_70170_p.field_72995_K) {
            if (this.getAttackTime() % 2 == 0) {
                this.startAttack();
            }
            this.setAttackTime(this.getAttackTime() - 1);
        }
    }

    protected void startAttack() {
        EntityLivingBase target = this.func_70638_az();
        if (target == null) {
            return;
        }
        EntityThorn thorn = new EntityThorn(this.field_70170_p, (EntityLivingBase)this);
        thorn.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        thorn.shoot();
        this.field_70170_p.func_72838_d((Entity)thorn);
    }

    @Override
    protected boolean checkWeak() {
        int k;
        int j;
        if (this.isImmuneToWeak) {
            return false;
        }
        Entity entity = this.func_184187_bx();
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v));
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        return block != BlockRegister.LILY_PAD;
    }

    public int getShootSpeed() {
        return 30;
    }

    @Override
    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 18) {
            int now = (lvl - 1) / 2;
            return now + 2;
        }
        if (lvl <= 20) {
            return 20.0f;
        }
        return 2.0f;
    }

    @Override
    public int getSuperTimeLength() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return 200;
        }
        if (lvl <= 13) {
            return 250;
        }
        if (lvl <= 20) {
            return 300;
        }
        return 200;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CAT_TAIL;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.setAttackTime(4);
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

