/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.plants.magic;

import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.damage.PVZDamageType;
import com.hungteen.pvzmod.entities.plants.base.EntityShroomBase;
import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.entities.zombies.roof.EntityGargantuar;
import com.hungteen.pvzmod.util.enums.Plants;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityHypnoShroom
extends EntityShroomBase {
    public EntityHypnoShroom(World worldIn) {
        super(worldIn);
    }

    @Override
    public int getSuperTimeLength() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return 24000;
        }
        if (lvl <= 13) {
            return 48000;
        }
        if (lvl <= 20) {
            return 72000;
        }
        return 24000;
    }

    public void func_70645_a(DamageSource cause) {
        Entity attacker;
        PVZDamageSource source;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.getIsSleeping() && cause instanceof PVZDamageSource && (source = (PVZDamageSource)cause).getPVZDamageType() == PVZDamageType.EAT && (attacker = source.func_76346_g()) instanceof EntityZombieBase) {
            if (this.isPlantInSuperMode()) {
                attacker.func_70097_a((DamageSource)PVZDamageSource.causeMagicDamage((Entity)this, (Entity)this), ((EntityZombieBase)attacker).func_110143_aJ());
                EntityGargantuar gar = new EntityGargantuar(this.field_70170_p);
                gar.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                gar.setZombieMaxHealth(gar.func_110143_aJ() * this.superLifeBuff());
                gar.setIsCharmed(true);
                gar.setZombieType(EntityZombieBase.Type.NORMAL);
                this.field_70170_p.func_72838_d((Entity)gar);
            } else {
                ((EntityZombieBase)attacker).setIsCharmed(true);
                ((EntityZombieBase)attacker).setZombieMaxHealth(((EntityZombieBase)attacker).func_110143_aJ() * this.normalLifeBuff());
            }
        }
    }

    private float superLifeBuff() {
        int lvl = this.getPlantLvl();
        if (lvl <= 6) {
            return 0.5f;
        }
        if (lvl <= 13) {
            return 1.0f;
        }
        if (lvl <= 20) {
            return 1.5f;
        }
        return 0.5f;
    }

    private float normalLifeBuff() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            return 1.0f + (float)now / 10.0f;
        }
        return 1.0f;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.HYPNO_SHROOM;
    }

    public static enum State {
        NORMAL,
        SUPER;

    }
}

