/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.zombies;

import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.entities.zombies.special.EntityElementBall;
import com.hungteen.pvzmod.entities.zombies.special.EntityNormalDefence;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityZomBoss
extends EntityZombieBase
implements IEntityMultiPart {
    public EntityNormalDefence body1 = new EntityNormalDefence(this, "body1", 3.0f, 3.0f);
    public EntityNormalDefence body2 = new EntityNormalDefence(this, "body2", 3.0f, 3.0f);
    public EntityNormalDefence body3 = new EntityNormalDefence(this, "body3", 3.0f, 3.0f);
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityZomBoss.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ATTACK_TIME = EntityDataManager.func_187226_a(EntityZomBoss.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> NORMAL_TIME = EntityDataManager.func_187226_a(EntityZomBoss.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THROW_TIME = EntityDataManager.func_187226_a(EntityZomBoss.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityZomBoss(World worldIn) {
        super(worldIn);
        this.func_70105_a(5.0f, 18.0f);
    }

    @Override
    protected EntityZombieBase.Type getType() {
        return EntityZombieBase.Type.NORMAL;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)State.NORMAL.ordinal());
        this.field_70180_af.func_187214_a(ATTACK_TIME, (Object)0);
        this.field_70180_af.func_187214_a(NORMAL_TIME, (Object)0);
        this.field_70180_af.func_187214_a(THROW_TIME, (Object)0);
    }

    @Override
    public float getLife() {
        return 3000.0f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.16f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.initAITargetTask();
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.updateBody();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            EntityLivingBase target = this.func_70638_az();
            this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() >= this.getAttackTick()) {
                    EntityElementBall ball = new EntityElementBall(this.field_70170_p, this.getBossState().ordinal());
                    ball.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 1.0, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)ball);
                    this.setAttackTime(0);
                    this.setBossState(State.NORMAL);
                }
            } else if (this.getThrowTime() <= 0) {
                this.setNormalTime(this.getNormalTime() + 1);
                if (this.getNormalTime() >= this.getAttackCD()) {
                    int chance = this.func_70681_au().nextInt(100);
                    this.setAttackTime(1);
                    int type = this.func_70681_au().nextInt(2);
                    this.setBossState(State.values()[type + 1]);
                    this.setNormalTime(0);
                }
            }
        }
    }

    private void updateBody() {
        this.body1.func_70071_h_();
        this.body1.func_70080_a(this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        this.body2.func_70071_h_();
        this.body2.func_70080_a(this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        this.body3.func_70071_h_();
        this.body3.func_70080_a(this.field_70165_t, this.field_70163_u + 12.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
    }

    public int getAttackCD() {
        return 400;
    }

    @Override
    public int getAttackTick() {
        return 50;
    }

    public int getThrowTick() {
        return 50;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean getCanBeInvis() {
        return false;
    }

    @Override
    public boolean getCanBeSmall() {
        return false;
    }

    @Override
    public boolean getCanBeButter() {
        return false;
    }

    @Override
    public boolean getCanBeFrozen() {
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setAttackTime(compund.func_74762_e("zombie_attack_time"));
        this.setThrowTime(compund.func_74762_e("zombie_throw_time"));
        this.setNormalTime(compund.func_74762_e("zombie_normal_time"));
        this.setBossState(State.values()[compund.func_74762_e("zombie_boss_state")]);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("zombie_attack_time", this.getAttackTime());
        compound.func_74768_a("zombie_throw_time", this.getThrowTime());
        compound.func_74768_a("zombie_normal_time", this.getNormalTime());
        compound.func_74768_a("zombie_boss_state", this.getBossState().ordinal());
    }

    public int getAttackTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TIME);
    }

    public void setAttackTime(int cd) {
        this.field_70180_af.func_187227_b(ATTACK_TIME, (Object)cd);
    }

    public int getThrowTime() {
        return (Integer)this.field_70180_af.func_187225_a(THROW_TIME);
    }

    public void setThrowTime(int cd) {
        this.field_70180_af.func_187227_b(THROW_TIME, (Object)cd);
    }

    public int getNormalTime() {
        return (Integer)this.field_70180_af.func_187225_a(NORMAL_TIME);
    }

    public void setNormalTime(int cd) {
        this.field_70180_af.func_187227_b(NORMAL_TIME, (Object)cd);
    }

    public State getBossState() {
        return State.values()[(Integer)this.field_70180_af.func_187225_a(STATE)];
    }

    public void setBossState(State state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state.ordinal());
    }

    @Override
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsHandler.GAR_DIE;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsHandler.METAL_HURT;
    }

    public Entity[] func_70021_al() {
        return new Entity[]{this.body1, this.body2, this.body3};
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart dragonPart, DamageSource source, float damage) {
        return this.func_70097_a(source, damage);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.ZOMBOSS;
    }

    public static enum State {
        NORMAL,
        ICE,
        FLAME;

    }
}

