/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.zombies.base;

import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.damage.PVZDamageType;
import com.hungteen.pvzmod.entities.ai.EntityAIZombieEat;
import com.hungteen.pvzmod.entities.ai.target.PVZAIZombieGlobalTarget;
import com.hungteen.pvzmod.entities.plants.base.EntityPlantBase;
import com.hungteen.pvzmod.entities.plants.common.EntityKernelPult;
import com.hungteen.pvzmod.registry.PotionRegister;
import com.hungteen.pvzmod.util.ConfigurationUtil;
import com.hungteen.pvzmod.util.EntityUtil;
import com.hungteen.pvzmod.util.PlantsUtil;
import com.hungteen.pvzmod.util.PlayerUtil;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.ZombieUtil;
import com.hungteen.pvzmod.util.enums.Plants;
import com.hungteen.pvzmod.util.enums.Ranks;
import com.hungteen.pvzmod.util.enums.SpecialEvents;
import com.hungteen.pvzmod.util.interfaces.IZombie;
import com.hungteen.pvzmod.world.data.OverworldData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class EntityZombieBase
extends EntityMob
implements IZombie {
    private static final DataParameter<Integer> ZOMBIE_TYPE = EntityDataManager.func_187226_a(EntityZombieBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> OWNER_NAME = EntityDataManager.func_187226_a(EntityZombieBase.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> IS_FROZEN = EntityDataManager.func_187226_a(EntityZombieBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_COLD = EntityDataManager.func_187226_a(EntityZombieBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_CHARMED = EntityDataManager.func_187226_a(EntityZombieBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SMALL = EntityDataManager.func_187226_a(EntityZombieBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_INVIS = EntityDataManager.func_187226_a(EntityZombieBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_BUTTER = EntityDataManager.func_187226_a(EntityZombieBase.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityZombieBase(World worldIn) {
        super(worldIn);
        this.getType();
        this.setZombieAttributes();
        this.field_70178_ae = true;
    }

    protected void setZombieAttributes() {
        this.setZombieMaxHealth(this.getLife());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ZOMBIE_TYPE, (Object)this.getType().ordinal());
        this.field_70180_af.func_187214_a(OWNER_NAME, (Object)"");
        this.field_70180_af.func_187214_a(IS_FROZEN, (Object)false);
        this.field_70180_af.func_187214_a(IS_COLD, (Object)false);
        this.field_70180_af.func_187214_a(IS_CHARMED, (Object)false);
        this.field_70180_af.func_187214_a(IS_SMALL, (Object)false);
        this.field_70180_af.func_187214_a(IS_INVIS, (Object)false);
        this.field_70180_af.func_187214_a(IS_BUTTER, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIZombieEat((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.initAITargetTask();
    }

    protected void initAITargetTask() {
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new PVZAIZombieGlobalTarget((EntityCreature)this, 100.0f, 100.0f));
    }

    protected Type getType() {
        int t = this.func_70681_au().nextInt(100);
        if (t <= 3 - ConfigurationUtil.getPVZDifficulty()) {
            return Type.SUPER;
        }
        return Type.NORMAL;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.zombieSpawnInit();
        return super.func_180482_a(difficulty, livingdata);
    }

    public void zombieSpawnInit() {
        OverworldData data = OverworldData.getGlobalData(this.field_70170_p);
        if (data.hasEvent(SpecialEvents.INVIS_ZOMBIE) && this.getCanBeInvis()) {
            this.setIsInvis(true);
            this.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 9999999, 0, false, false));
        }
        if (data.hasEvent(SpecialEvents.MINI_ZOMBIE) && this.getCanBeSmall()) {
            this.setIsSmall(true);
            this.func_70105_a(0.2f, 0.3f);
            this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 9999999, 0, false, false));
            this.func_70690_d(new PotionEffect(PotionRegister.SMALL_LIFE_EFFECT, 9999999, 4, false, false));
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = this.dealAttackDamage(f, entityIn)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected boolean dealAttackDamage(float damage, Entity target) {
        return target.func_70097_a((DamageSource)PVZDamageSource.causeEatDamage((Entity)this, (Entity)this), damage);
    }

    public boolean func_70067_L() {
        return this.func_110143_aJ() > 0.0f;
    }

    public void func_70108_f(Entity entityIn) {
        if (!(this.func_184223_x(entityIn) || entityIn.field_70145_X || this.field_70145_X)) {
            double d0 = entityIn.field_70165_t - this.field_70165_t;
            double d1 = entityIn.field_70161_v - this.field_70161_v;
            double d2 = MathHelper.func_76132_a((double)d0, (double)d1);
            if (d2 >= (double)0.01f) {
                d2 = MathHelper.func_76133_a((double)d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                d0 *= (double)(1.0f - this.field_70144_Y);
                d1 *= (double)(1.0f - this.field_70144_Y);
                if (!this.func_184207_aI() && !(entityIn instanceof EntityZombieBase)) {
                    this.func_70024_g(-d0, 0.0, -d1);
                }
                if (!entityIn.func_184207_aI() && !(entityIn instanceof EntityPlantBase)) {
                    entityIn.func_70024_g(d0, 0.0, d1);
                }
            } else {
                this.func_70024_g(this.func_70681_au().nextFloat() - 0.5f, 0.0, this.func_70681_au().nextFloat() - 0.5f);
                entityIn.func_70024_g((double)(this.func_70681_au().nextFloat() - 0.5f), 0.0, (double)(this.func_70681_au().nextFloat() - 0.5f));
            }
        }
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_72872_a(EntityLiving.class, this.func_174813_aQ());
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_180263_c("maxEntityCramming");
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (((Entity)list.get(k)).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (!EntityUtil.checkShouldApplyCollision((Entity)this, entity)) continue;
                this.func_82167_n(entity);
            }
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70644_a(PotionRegister.FROZEN_EFFECT)) {
                this.setIsFrozen(true);
            } else {
                this.setIsFrozen(false);
            }
            if (this.func_70644_a(PotionRegister.COLD_EFFECT)) {
                this.setIsCold(true);
            } else {
                this.setIsCold(false);
            }
            if (this.func_70644_a(PotionRegister.BUTTER_EFFECT)) {
                this.setIsButter(true);
            } else {
                this.setIsButter(false);
            }
        }
        if (this.getIsSmall()) {
            this.setSmallSize();
        }
        if (this.getIsFrozen() || this.getIsButter()) {
            return;
        }
        this.onNormalZombieUpdate();
    }

    protected void onNormalZombieUpdate() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("zombie_type", this.getZombieType().ordinal());
        if (!this.getOwnerName().equals("")) {
            compound.func_74778_a("zombie_owner_name", this.getOwnerName());
        }
        compound.func_74757_a("is_zombie_cold", this.getIsCold());
        compound.func_74757_a("is_zombie_frozen", this.getIsFrozen());
        compound.func_74757_a("is_zombie_butter", this.getIsButter());
        compound.func_74757_a("is_zombie_small", this.getIsSmall());
        compound.func_74757_a("is_zombie_invis", this.getIsInivs());
        compound.func_74757_a("is_zombie_charmed", this.getIsCharmed());
    }

    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setZombieType(Type.values()[compund.func_74762_e("zombie_type")]);
        if (compund.func_74764_b("ownerName")) {
            this.setOwnerName(compund.func_74779_i("zombie_owner_name"));
        } else {
            this.setOwnerName("");
        }
        this.setIsCold(compund.func_74767_n("is_zombie_cold"));
        this.setIsFrozen(compund.func_74767_n("is_zombie_frozen"));
        this.setIsButter(compund.func_74767_n("is_zombie_butter"));
        this.setIsSmall(compund.func_74767_n("is_zombie_small"));
        this.setIsInvis(compund.func_74767_n("is_zombie_invis"));
        this.setIsCharmed(compund.func_74767_n("is_zombie_charmed"));
    }

    @Nullable
    public String getOwnerName() {
        return (String)this.field_70180_af.func_187225_a(OWNER_NAME);
    }

    public void setOwnerName(String name) {
        this.field_70180_af.func_187227_b(OWNER_NAME, (Object)name);
    }

    public void setIsCharmed(boolean is) {
        this.field_70180_af.func_187227_b(IS_CHARMED, (Object)is);
    }

    public void setIsInvis(boolean is) {
        this.field_70180_af.func_187227_b(IS_INVIS, (Object)is);
    }

    public void setIsSmall(boolean is) {
        this.field_70180_af.func_187227_b(IS_SMALL, (Object)is);
    }

    public void setIsCold(boolean is) {
        this.field_70180_af.func_187227_b(IS_COLD, (Object)is);
    }

    public void setIsFrozen(boolean is) {
        this.field_70180_af.func_187227_b(IS_FROZEN, (Object)is);
    }

    public void setIsButter(boolean is) {
        this.field_70180_af.func_187227_b(IS_BUTTER, (Object)is);
    }

    public void setZombieType(Type type) {
        this.field_70180_af.func_187227_b(ZOMBIE_TYPE, (Object)type.ordinal());
    }

    public boolean getIsCharmed() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CHARMED);
    }

    public boolean getIsInivs() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_INVIS);
    }

    public boolean getIsSmall() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SMALL);
    }

    public boolean getIsButter() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BUTTER);
    }

    public boolean getIsCold() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_COLD);
    }

    public boolean getIsFrozen() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FROZEN);
    }

    public int getAttackTick() {
        if (this.func_70644_a(PotionRegister.COLD_EFFECT)) {
            int lvl = this.func_70660_b(PotionRegister.COLD_EFFECT).func_76458_c();
            return 4 * lvl + 10;
        }
        return 10;
    }

    public Type getZombieType() {
        return Type.values()[(Integer)this.field_70180_af.func_187225_a(ZOMBIE_TYPE)];
    }

    protected SoundEvent func_184639_G() {
        return SoundsHandler.ZOMBIE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected void setSmallSize() {
        this.func_70105_a(0.3f, 0.4f);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause instanceof PVZDamageSource) {
            Entity entity = cause.func_76346_g();
            if (entity instanceof EntityPlantBase) {
                EntityPlayer player;
                if (((EntityPlantBase)entity).getOwnerName() != "" && (player = this.field_70170_p.func_72924_a(((EntityPlantBase)entity).getOwnerName())) != null) {
                    PlayerUtil.addPlantCardNum(player, ((EntityPlantBase)entity).getPlantEnumName(), 1);
                }
            } else if (entity instanceof EntityPlayer) {
                PlayerUtil.addPlayerXp((EntityPlayer)entity, 1);
            }
        } else if (cause.func_76346_g() instanceof EntityPlayer) {
            PlayerUtil.addPlayerXp((EntityPlayer)cause.func_76346_g(), 1);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag2;
        PVZDamageSource src;
        if (!ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (source.func_76347_k() && this.func_70644_a(MobEffects.field_76426_n)) {
            return false;
        }
        float f = amount;
        if (!(source != DamageSource.field_82728_o && source != DamageSource.field_82729_p || this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b())) {
            this.func_184582_a(EntityEquipmentSlot.HEAD).func_77972_a((int)(amount * 4.0f + this.field_70146_Z.nextFloat() * amount * 2.0f), (EntityLivingBase)this);
            amount *= 0.75f;
        }
        if (source.func_76355_l() == "drown") {
            amount *= 5.0f;
        }
        boolean flag = false;
        this.field_70721_aZ = 1.5f;
        boolean flag1 = true;
        this.field_110153_bc = amount;
        this.func_70665_d(source, amount);
        if (source instanceof PVZDamageSource && (src = (PVZDamageSource)source).func_76346_g() instanceof EntityPlantBase) {
            PotionEffect coldEffect;
            EntityPlantBase entityPlant = (EntityPlantBase)src.func_76346_g();
            Plants plant = entityPlant.getPlantEnumName();
            if (src.field_76373_n == PVZDamageType.SNOW) {
                coldEffect = PlantsUtil.getColdPotionEffect(entityPlant);
                if (coldEffect != null) {
                    this.func_70690_d(coldEffect);
                }
                this.func_184185_a(SoundsHandler.FROZEN_PEA, 0.5f, 1.0f);
            } else if (src.field_76373_n == PVZDamageType.ICE) {
                coldEffect = PlantsUtil.getColdPotionEffect(entityPlant);
                if (coldEffect != null) {
                    this.func_70690_d(coldEffect);
                }
                this.func_184185_a(SoundsHandler.FROZEN_PEA, 0.5f, 1.0f);
                PotionEffect frozenEffect = PlantsUtil.getFrozenPotionEffect(entityPlant);
                if (frozenEffect != null && this.getCanBeFrozen()) {
                    this.func_70690_d(frozenEffect);
                }
            } else if (src.field_76373_n == PVZDamageType.FIRE) {
                this.func_184185_a(SoundsHandler.FIRE_PEA, 4.0f, 1.0f);
                if (this.func_70644_a(PotionRegister.COLD_EFFECT)) {
                    this.func_184589_d(PotionRegister.COLD_EFFECT);
                }
                if (this.func_70644_a(PotionRegister.FROZEN_EFFECT)) {
                    this.func_184589_d(PotionRegister.FROZEN_EFFECT);
                }
            } else if (src.field_76373_n == PVZDamageType.BUTTER && this.getCanBeButter() && src.func_76346_g() instanceof EntityKernelPult) {
                this.func_70690_d(((EntityKernelPult)src.func_76346_g()).getButterEffect());
            }
        }
        this.field_70739_aP = 0.0f;
        Entity entity1 = source.func_76346_g();
        if (entity1 != null) {
            EntityTameable entitywolf;
            if (entity1 instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)entity1);
            }
            if (entity1 instanceof EntityPlayer) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (EntityPlayer)entity1;
            } else if (entity1 instanceof EntityTameable && (entitywolf = (EntityTameable)entity1).func_70909_n()) {
                this.field_70718_bc = 100;
                this.field_70717_bb = null;
            }
        }
        if (flag1) {
            if (flag) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)33);
            } else {
                byte b0 = source == DamageSource.field_76369_e ? (byte)36 : (source.func_76347_k() ? (byte)37 : 2);
                this.field_70170_p.func_72960_a((Entity)this, b0);
            }
            if (source != DamageSource.field_76369_e && (!flag || amount > 0.0f)) {
                this.func_70018_K();
            }
            if (entity1 != null) {
                double d1 = entity1.field_70165_t - this.field_70165_t;
                double d0 = entity1.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)this.field_70177_z);
                this.func_70653_a(entity1, 0.4f, d1, d0);
            } else {
                this.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            SoundEvent soundevent = this.func_184615_bR();
            if (flag1 && soundevent != null) {
                this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
            }
            this.func_70645_a(source);
        } else if (flag1) {
            this.func_184581_c(source);
        }
        boolean bl = flag2 = !flag || amount > 0.0f;
        if (entity1 instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192127_g.func_192220_a((EntityPlayerMP)entity1, (Entity)this, source, f, amount, flag);
        }
        return flag2;
    }

    public void setZombieMaxHealth(float health) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)health);
        this.func_70691_i(health);
    }

    public boolean getCanBeButter() {
        return true;
    }

    public boolean getCanBeFrozen() {
        return true;
    }

    public boolean getCanBeSmall() {
        return true;
    }

    public boolean getCanBeInvis() {
        return true;
    }

    @Override
    public Ranks getZombieRank() {
        return ZombieUtil.getZombieRank(this.getZombieEnumName());
    }

    @Override
    public int getZombieXp() {
        return ZombieUtil.getZombieXp(this.getZombieEnumName());
    }

    protected boolean func_70814_o() {
        return true;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public static enum Type {
        NORMAL,
        SUPER,
        BEARD;

    }
}

