/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.zombies.grassnight;

import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.entities.zombies.special.EntityNormalDefence;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityPaperZombie
extends EntityZombieBase
implements IEntityMultiPart {
    private static final DataParameter<Boolean> IS_ANGRY = EntityDataManager.func_187226_a(EntityPaperZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    public EntityNormalDefence paper = new EntityNormalDefence(this, "paper", 1.0f, 1.5f);

    public EntityPaperZombie(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 2.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_ANGRY, (Object)false);
    }

    @Override
    public float getLife() {
        return 36.0f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.19f);
    }

    @Override
    protected void setSmallSize() {
        this.func_70105_a(0.3f, 0.4f);
        this.paper.setSmallSize(0.3f, 0.5f);
    }

    protected float getDefenceDis() {
        if (this.getIsSmall()) {
            return 0.2f;
        }
        return 0.7f;
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.paper.func_70071_h_();
        float j = 6.28318f * this.field_70177_z / 360.0f;
        float dis = this.getDefenceDis();
        this.paper.func_70012_b(this.field_70165_t - Math.sin(j) * (double)dis, this.field_70163_u + (double)0.2f, this.field_70161_v + Math.cos(j) * (double)dis, this.field_70177_z, this.field_70125_A);
    }

    @Override
    protected void onNormalZombieUpdate() {
        super.onNormalZombieUpdate();
        if (this.func_110143_aJ() <= this.func_110138_aP() / 3.0f && !this.getIsAngry()) {
            this.func_184185_a(SoundsHandler.PAPER_OUT, 4.0f, 1.0f);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getAngrySpeed());
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getAngryDamage());
            this.func_184185_a(SoundsHandler.PAPER_ANGRY, 4.0f, 1.0f);
            this.setIsAngry(true);
        }
    }

    protected float getAngryDamage() {
        return 10.0f;
    }

    protected float getAngrySpeed() {
        return 0.24f;
    }

    public void setIsAngry(boolean is) {
        this.field_70180_af.func_187227_b(IS_ANGRY, (Object)is);
    }

    public boolean getIsAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ANGRY);
    }

    @Override
    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setIsAngry(compund.func_74767_n("is_paper_out"));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("is_paper_out", this.getIsAngry());
    }

    public Entity[] func_70021_al() {
        return new Entity[]{this.paper};
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart dragonPart, DamageSource source, float damage) {
        return this.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage(source.func_76364_f(), source.func_76346_g()), damage);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.PAPER_ZOMBIE;
    }
}

