/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.zombies.roof;

import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.entities.ai.attack.PVZAIZombiePultAttack;
import com.hungteen.pvzmod.entities.bullets.EntityBall;
import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityCataPultZombie
extends EntityZombieBase
implements IRangedAttackMob {
    private static final DataParameter<Integer> ATTACK_TIME = EntityDataManager.func_187226_a(EntityCataPultZombie.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_ATTACKED = EntityDataManager.func_187226_a(EntityCataPultZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_OUT = EntityDataManager.func_187226_a(EntityCataPultZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CAN_ATTACK_NOW = EntityDataManager.func_187226_a(EntityCataPultZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private float LENTH = 0.1f;

    public EntityCataPultZombie(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 2.0f);
    }

    @Override
    protected void setSmallSize() {
        this.func_70105_a(0.6f, 0.5f);
    }

    @Override
    protected EntityZombieBase.Type getType() {
        return EntityZombieBase.Type.NORMAL;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TIME, (Object)0);
        this.field_70180_af.func_187214_a(IS_ATTACKED, (Object)false);
        this.field_70180_af.func_187214_a(IS_OUT, (Object)false);
        this.field_70180_af.func_187214_a(CAN_ATTACK_NOW, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new PVZAIZombiePultAttack(this, 50.0f));
        this.initAITargetTask();
    }

    @Override
    public float getLife() {
        return 90.0f;
    }

    @Override
    protected boolean dealAttackDamage(float damage, Entity target) {
        if (target instanceof EntityLivingBase) {
            return target.func_70097_a((DamageSource)PVZDamageSource.causeDeadDamage((Entity)this, (Entity)this), ((EntityLivingBase)target).func_110138_aP());
        }
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.18f);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("zombie_attack_time", this.getAttackTime());
        compound.func_74757_a("isAttacked", this.getIsAttacked());
        compound.func_74757_a("isOut", this.getIsOut());
        compound.func_74757_a("canAttackNow", this.getCanAttackNow());
    }

    @Override
    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setAttackTime(compund.func_74762_e("zombie_attack_time"));
        this.setIsAttacked(compund.func_74767_n("isAttacked"));
        this.setIsOut(compund.func_74767_n("isOut"));
        this.setCanAttackNow(compund.func_74767_n("canAttackNow"));
    }

    @Override
    public void onNormalZombieUpdate() {
        super.onNormalZombieUpdate();
        if (this.func_70638_az() != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.18f);
        }
        if (this.getIsAttacked()) {
            this.setAttackTime(0);
            this.setCanAttackNow(true);
            this.setIsAttacked(false);
        }
        if (this.getCanAttackNow()) {
            if (this.getAttackTime() >= 20) {
                this.setCanAttackNow(false);
                this.setAttackTime(0);
                this.setIsOut(false);
            } else if (this.getAttackTime() == 8) {
                this.setIsOut(true);
                if (!this.field_70170_p.field_72995_K) {
                    this.throwBullet();
                }
            }
        }
        this.setAttackTime(this.getAttackTime() + 1);
    }

    private void throwBullet() {
        if (this.func_70638_az() == null) {
            return;
        }
        EntityLivingBase target = this.func_70638_az();
        double dx = target.field_70165_t - this.field_70165_t;
        double dz = target.field_70161_v - this.field_70161_v;
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double tmp = (double)this.LENTH / dis;
        double deltaX = tmp * dx;
        double deltaZ = tmp * dz;
        EntityBall cabbage = new EntityBall(this.field_70170_p, (EntityLivingBase)this);
        cabbage.func_70107_b(this.field_70165_t - deltaX, this.field_70163_u + (double)1.7f, this.field_70161_v - deltaZ);
        cabbage.shoot(target.field_70165_t - cabbage.field_70165_t, target.field_70163_u - cabbage.field_70163_u + 0.5, target.field_70161_v - cabbage.field_70161_v);
        this.func_184185_a(SoundsHandler.BALL_SHOOT, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)cabbage);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.setIsAttacked(true);
        this.func_70624_b(target);
    }

    public int getPultSpeed() {
        return 50;
    }

    public int getAttackTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TIME);
    }

    public void setAttackTime(int cd) {
        this.field_70180_af.func_187227_b(ATTACK_TIME, (Object)cd);
    }

    public void setIsAttacked(boolean isAttacked) {
        this.field_70180_af.func_187227_b(IS_ATTACKED, (Object)isAttacked);
    }

    public boolean getIsAttacked() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ATTACKED);
    }

    public void setIsOut(boolean isOut) {
        this.field_70180_af.func_187227_b(IS_OUT, (Object)isOut);
    }

    public boolean getIsOut() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_OUT);
    }

    public void setCanAttackNow(boolean canAttackNow) {
        this.field_70180_af.func_187227_b(CAN_ATTACK_NOW, (Object)canAttackNow);
    }

    public boolean getCanAttackNow() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_ATTACK_NOW);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.CATAPULT_ZOMBIE;
    }
}

