/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.zombies.roof;

import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.entities.ai.PVZAIGargantuarAttack;
import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.entities.zombies.roof.EntityImp;
import com.hungteen.pvzmod.registry.BlockRegister;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.enums.Zombies;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityGargantuar
extends EntityZombieBase {
    private static final DataParameter<Integer> ATTACK_TIME = EntityDataManager.func_187226_a(EntityGargantuar.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THROW_TIME = EntityDataManager.func_187226_a(EntityGargantuar.class, (DataSerializer)DataSerializers.field_187192_b);
    private Entity rider = null;

    public EntityGargantuar(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.0f, 5.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TIME, (Object)0);
        this.field_70180_af.func_187214_a(THROW_TIME, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new PVZAIGargantuarAttack((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 2.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.initAITargetTask();
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        int rand = this.func_70681_au().nextInt(3);
        if (rand == 0) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Item.func_150898_a((Block)BlockRegister.POLE)));
        } else if (rand == 1) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Item.func_150898_a((Block)BlockRegister.ZOMBIE_DOLL)));
        } else if (rand == 2) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Item.func_150898_a((Block)BlockRegister.WARNING_SIGN)));
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityImp imp = new EntityImp(this.field_70170_p);
            imp.func_70012_b(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.field_70170_p.func_72838_d((Entity)imp);
            imp.func_184220_m((Entity)this);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.16f);
    }

    @Override
    protected boolean dealAttackDamage(float damage, Entity target) {
        if (target instanceof EntityLivingBase) {
            return target.func_70097_a((DamageSource)PVZDamageSource.causeDeadDamage((Entity)this, (Entity)this), ((EntityLivingBase)target).func_110138_aP());
        }
        return false;
    }

    @Override
    public void onNormalZombieUpdate() {
        super.onNormalZombieUpdate();
        if (!this.field_70170_p.field_72995_K && this.getThrowTime() > 0) {
            this.setThrowTime(this.getThrowTime() + 1);
            if (this.getThrowTime() >= this.getThrowTick() / 2 && this.rider != null) {
                this.rider.func_184210_p();
                if (this.func_70638_az() != null) {
                    EntityLivingBase target = this.func_70638_az();
                    double dis = Math.sqrt((target.field_70165_t - this.rider.field_70165_t) * (target.field_70165_t - this.rider.field_70165_t) + (target.field_70161_v - this.rider.field_70161_v) * (target.field_70161_v - this.rider.field_70161_v));
                    this.rider.field_70159_w = (target.field_70165_t - this.rider.field_70165_t) / dis * 2.0;
                    this.rider.field_70181_x = 0.6f;
                    this.rider.field_70179_y = (target.field_70161_v - this.rider.field_70161_v) / dis * 2.0;
                } else {
                    this.rider.field_70159_w = this.func_70681_au().nextFloat() - 0.5f;
                    this.rider.field_70181_x = 0.6f;
                    this.rider.field_70179_y = this.func_70681_au().nextFloat() - 0.5f;
                }
                this.func_184185_a(SoundsHandler.IMP, 1.0f, 1.0f);
                this.rider = null;
            }
            if (this.getThrowTime() == this.getThrowTick()) {
                this.setThrowTime(0);
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.getThrowTime() == 0 && !this.func_184188_bt().isEmpty()) {
            this.rider = (Entity)this.func_184188_bt().get(0);
            this.setThrowTime(1);
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null) {
                EntityLivingBase target = this.func_70638_az();
                if (this.getAttackTime() < this.getAttackTick()) {
                    if (this.func_70068_e((Entity)target) <= (double)((this.field_70130_N / 2.0f + target.field_70130_N / 2.0f + 1.0f) * (this.field_70130_N / 2.0f + target.field_70130_N / 2.0f + 1.0f))) {
                        this.setAttackTime(this.getAttackTime() + 1);
                    } else {
                        this.setAttackTime(0);
                    }
                } else {
                    this.setAttackTime(0);
                    target.func_70097_a((DamageSource)PVZDamageSource.causeDeadDamage((Entity)this, (Entity)this), target.func_110143_aJ());
                    this.func_184185_a(SoundsHandler.GROUND_SHAKE, 1.0f, 1.0f);
                }
            } else {
                this.setAttackTime(0);
            }
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float len = 1.2f;
            float j = 6.28318f * this.field_70177_z / 360.0f;
            passenger.func_70107_b(this.field_70165_t + Math.sin(j) * (double)len, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() + 0.7, this.field_70161_v - Math.cos(j) * (double)len);
        }
    }

    @Override
    public int getAttackTick() {
        return 50;
    }

    public int getThrowTick() {
        return 50;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setAttackTime(compund.func_74762_e("zombie_attack_time"));
        this.setThrowTime(compund.func_74762_e("zombie_throw_time"));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("zombie_attack_time", this.getAttackTime());
        compound.func_74768_a("zombie_throw_time", this.getThrowTime());
    }

    public int getAttackTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TIME);
    }

    public void setAttackTime(int cd) {
        this.field_70180_af.func_187227_b(ATTACK_TIME, (Object)cd);
    }

    public int getThrowTime() {
        return (Integer)this.field_70180_af.func_187225_a(THROW_TIME);
    }

    public void setThrowTime(int cd) {
        this.field_70180_af.func_187227_b(THROW_TIME, (Object)cd);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundsHandler.GAR_AMBIENT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsHandler.GAR_DIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.GARGANTUAR;
    }

    @Override
    public float getLife() {
        return 300.0f;
    }
}

