/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.entities.zombies.special;

import com.hungteen.pvzmod.Main;
import com.hungteen.pvzmod.damage.PVZDamageSource;
import com.hungteen.pvzmod.entities.ai.EntityAIZombieEat;
import com.hungteen.pvzmod.entities.plants.flame.EntityJalapeno;
import com.hungteen.pvzmod.entities.plants.ice.EntityIceShroom;
import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.particles.base.PVZParticleType;
import com.hungteen.pvzmod.util.EntityUtil;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.enums.Zombies;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityElementBall
extends EntityZombieBase {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityElementBall.class, (DataSerializer)DataSerializers.field_187192_b);
    private final float speed = 0.5f;

    public EntityElementBall(World worldIn) {
        this(worldIn, new Random().nextInt(2) + 1);
    }

    public EntityElementBall(World worldIn, int type) {
        super(worldIn);
        if (type - 1 < 0) {
            System.out.println("element_ball error type!");
            this.setBallState(State.values()[this.func_70681_au().nextInt(State.values().length)]);
        } else {
            this.setBallState(State.values()[type - 1]);
        }
        this.func_70105_a(4.0f, 4.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIZombieEat((EntityCreature)this, 1.0, false));
        this.initAITargetTask();
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null) {
                EntityLivingBase target = this.func_70638_az();
                double dx = target.field_70165_t - this.field_70165_t;
                double dy = target.field_70163_u - this.field_70163_u;
                double dz = target.field_70161_v - this.field_70161_v;
                double dis = Math.sqrt(dx * dx + dy * dy + dz * dz);
                double d = dx / dis;
                this.getClass();
                this.field_70159_w = d * 0.5;
                double d2 = dy / dis;
                this.getClass();
                this.field_70181_x = d2 * 0.5;
                double d3 = dz / dis;
                this.getClass();
                this.field_70179_y = d3 * 0.5;
            }
            if (this.field_70173_aa == 600) {
                this.func_70106_y();
            }
        }
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.doExplosion();
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        if (source instanceof PVZDamageSource) {
            PVZDamageSource pvzSource = (PVZDamageSource)source;
            Entity owner = pvzSource.func_76346_g();
            if (this.getBallState() == State.FLAME && owner instanceof EntityIceShroom) {
                this.func_70106_y();
            } else if (this.getBallState() == State.ICE && owner instanceof EntityJalapeno) {
                this.func_70106_y();
            }
        }
        return super.func_180431_b(source);
    }

    private void doExplosion() {
        for (int i = 1; i <= 100; ++i) {
            if (this.getBallState() == State.FLAME) {
                Main.proxy.spawnParticle(PVZParticleType.FLAME, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.func_70681_au().nextFloat() - 0.5, (double)this.func_70681_au().nextFloat() - 0.5, (double)this.func_70681_au().nextFloat() - 0.5);
                continue;
            }
            if (this.getBallState() != State.ICE) continue;
            Main.proxy.spawnParticle(PVZParticleType.SNOW, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.func_70681_au().nextFloat() - 0.5, (double)this.func_70681_au().nextFloat() - 0.5, (double)this.func_70681_au().nextFloat() - 0.5);
        }
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t + 3.0, this.field_70163_u + 3.0, this.field_70161_v + 3.0, this.field_70165_t - 3.0, this.field_70163_u - 3.0, this.field_70161_v - 3.0);
            for (Entity entity : EntityUtil.getEntityAttackableTarget((EntityLivingBase)this, aabb)) {
                entity.func_70097_a((DamageSource)PVZDamageSource.causeExplosionDamage((Entity)this, (Entity)this), ((EntityLivingBase)entity).func_110138_aP());
            }
            this.func_184185_a(SoundsHandler.CHERRY_BOMB, 1.0f, 1.0f);
        }
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return null;
    }

    public boolean func_189652_ae() {
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ball_state", this.getBallState().ordinal());
    }

    @Override
    public void func_70037_a(NBTTagCompound compund) {
        super.func_70037_a(compund);
        this.setBallState(State.values()[compund.func_74762_e("ball_state")]);
    }

    public void setBallState(State state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state.ordinal());
    }

    public State getBallState() {
        return State.values()[(Integer)this.field_70180_af.func_187225_a(STATE)];
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.TOOL;
    }

    @Override
    public float getLife() {
        return 10.0f;
    }

    public static enum State {
        ICE,
        FLAME;

    }
}

