/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.event;

import com.hungteen.pvzmod.entities.zombies.grassday.EntityBucketHeadZombie;
import com.hungteen.pvzmod.entities.zombies.grassday.EntityConeHeadZombie;
import com.hungteen.pvzmod.entities.zombies.grassday.EntityFlagZombie;
import com.hungteen.pvzmod.entities.zombies.grassday.EntityNormalZombie;
import com.hungteen.pvzmod.registry.EntitySpawnRegister;
import com.hungteen.pvzmod.util.ConfigurationUtil;
import com.hungteen.pvzmod.util.SoundsHandler;
import com.hungteen.pvzmod.util.StringUtil;
import com.hungteen.pvzmod.util.enums.SpecialEvents;
import com.hungteen.pvzmod.world.data.OverworldData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class OverworldEvents {
    private static final Random rand = new Random();

    public static void doTickCheck(TickEvent.WorldTickEvent ev) {
        long totalTime = ev.world.func_82737_E();
        if (totalTime <= 24000L * (long)OverworldEvents.getSafeDayLength()) {
            return;
        }
        int time = (int)(totalTime % 24000L);
        switch (time) {
            case 399: {
                OverworldData data = OverworldData.getGlobalData(ev.world);
                data.setChanged(false);
                break;
            }
            case 400: {
                OverworldData data = OverworldData.getGlobalData(ev.world);
                if (data.hasChanged()) break;
                data.setChanged(true);
                rand.setSeed(ev.world.func_72905_C() + totalTime);
                if (!data.isZombossDefeated() && rand.nextInt(100) >= OverworldEvents.getAttackChance(totalTime)) break;
                data.setAttack(true);
                System.out.println("start attack!");
                OverworldEvents.activateEvent(ev.world, SpecialEvents.NORMAL_ZOMBIE);
                OverworldEvents.activateEvent(ev.world, SpecialEvents.DAY_ZOMBIE);
                if (rand.nextInt(ConfigurationUtil.MainConfig.eventSettings.plantZombieEventChance) == 0) {
                    OverworldEvents.activateEvent(ev.world, SpecialEvents.PLANT_ZOMBIE);
                }
                if (rand.nextInt(ConfigurationUtil.MainConfig.eventSettings.miniZombieEventChance) == 0) {
                    OverworldEvents.activateEvent(ev.world, SpecialEvents.MINI_ZOMBIE);
                }
                if (rand.nextInt(ConfigurationUtil.MainConfig.eventSettings.invisZombieEventChance) == 0) {
                    OverworldEvents.activateEvent(ev.world, SpecialEvents.INVIS_ZOMBIE);
                }
                for (EntityPlayer pl : ev.world.field_73010_i) {
                    pl.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.huge_wave", TextFormatting.DARK_RED));
                    ev.world.func_184148_a(null, pl.field_70165_t, pl.field_70163_u, pl.field_70161_v, SoundsHandler.HUGE_WAVE, SoundCategory.AMBIENT, 1.0f, 1.0f);
                }
                break;
            }
            case 11599: {
                OverworldData data = OverworldData.getGlobalData(ev.world);
                data.setChanged(false);
                break;
            }
            case 11600: {
                OverworldData data = OverworldData.getGlobalData(ev.world);
                if (data.hasChanged()) break;
                data.setChanged(true);
                OverworldEvents.deactivateEvent(ev.world, SpecialEvents.DAY_ZOMBIE);
                break;
            }
            case 12399: {
                OverworldData data = OverworldData.getGlobalData(ev.world);
                data.setChanged(false);
                break;
            }
            case 12400: {
                OverworldData data = OverworldData.getGlobalData(ev.world);
                if (data.hasChanged()) break;
                data.setChanged(true);
                if (!data.isAttack()) break;
                OverworldEvents.activateEvent(ev.world, SpecialEvents.NIGHT_ZOMBIE);
                break;
            }
            case 23599: {
                OverworldData data = OverworldData.getGlobalData(ev.world);
                data.setChanged(false);
                break;
            }
            case 23600: {
                OverworldData data = OverworldData.getGlobalData(ev.world);
                if (data.hasChanged()) break;
                data.setChanged(false);
                OverworldEvents.deactivateEvent(ev.world, SpecialEvents.NORMAL_ZOMBIE);
                OverworldEvents.deactivateEvent(ev.world, SpecialEvents.NIGHT_ZOMBIE);
                OverworldEvents.deactivateEvent(ev.world, SpecialEvents.PLANT_ZOMBIE);
                OverworldEvents.deactivateEvent(ev.world, SpecialEvents.MINI_ZOMBIE);
                OverworldEvents.deactivateEvent(ev.world, SpecialEvents.INVIS_ZOMBIE);
                data.setAttack(false);
                break;
            }
        }
    }

    public static void activateEvent(World world, @Nonnull SpecialEvents event) {
        OverworldData data = OverworldData.getGlobalData(world);
        if (!data.hasEvent(event)) {
            data.add(event);
            switch (event) {
                case NORMAL_ZOMBIE: 
                case DAY_ZOMBIE: 
                case NIGHT_ZOMBIE: 
                case PLANT_ZOMBIE: {
                    EntitySpawnRegister.addEventSpawns(event);
                    break;
                }
            }
            switch (event) {
                case PLANT_ZOMBIE: 
                case MINI_ZOMBIE: 
                case INVIS_ZOMBIE: {
                    ITextComponent message = OverworldEvents.getEventMessage(event, false);
                    for (EntityPlayer pl : world.field_73010_i) {
                        pl.func_145747_a(message);
                    }
                    break;
                }
            }
        }
    }

    public static void deactivateEvent(World world, @Nonnull SpecialEvents event) {
        OverworldData data = OverworldData.getGlobalData(world);
        if (data.hasEvent(event)) {
            data.remove(event);
            switch (event) {
                case NORMAL_ZOMBIE: 
                case DAY_ZOMBIE: 
                case NIGHT_ZOMBIE: 
                case PLANT_ZOMBIE: {
                    EntitySpawnRegister.removeEventSpawns(event);
                    break;
                }
            }
            switch (event) {
                case PLANT_ZOMBIE: 
                case MINI_ZOMBIE: 
                case INVIS_ZOMBIE: {
                    ITextComponent message = OverworldEvents.getEventMessage(event, true);
                    for (EntityPlayer pl : world.field_73010_i) {
                        pl.func_145747_a(message);
                    }
                    break;
                }
            }
        }
    }

    private static ITextComponent getEventMessage(SpecialEvents event, boolean isEnding) {
        switch (event) {
            case PLANT_ZOMBIE: {
                return StringUtil.getColourLocale("message.event." + (isEnding ? "end" : "start") + ".plantZombieEvent", TextFormatting.DARK_GREEN);
            }
            case MINI_ZOMBIE: {
                return StringUtil.getColourLocale("message.event." + (isEnding ? "end" : "start") + ".miniZombieEvent", TextFormatting.DARK_GRAY);
            }
            case INVIS_ZOMBIE: {
                return StringUtil.getColourLocale("message.event." + (isEnding ? "end" : "start") + ".invisZombieEvent", TextFormatting.DARK_BLUE);
            }
        }
        return null;
    }

    private static void hugeWave(World world, int type) {
        for (EntityPlayer player : world.field_73010_i) {
            player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.huge_wave", TextFormatting.DARK_RED));
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            world.func_184148_a(null, x, y, z, SoundsHandler.HUGE_WAVE, SoundCategory.AMBIENT, 4.0f, 1.0f);
            if (player.func_184812_l_() || player.func_175149_v()) continue;
            BlockPos block = OverworldEvents.getBlock(world, x, y, z);
            OverworldEvents.summonZombie(world, block, 10, 1);
            OverworldEvents.summonZombie(world, block, 3, 2);
            OverworldEvents.summonZombie(world, block, 1, 3);
            OverworldEvents.summonZombie(world, block, 1, 4);
        }
    }

    private static void summonZombie(World world, BlockPos block, int num, int type) {
        for (int i = 1; i <= num; ++i) {
            EntityNormalZombie zombie = null;
            if (type == 1) {
                zombie = new EntityNormalZombie(world);
            } else if (type == 2) {
                zombie = new EntityConeHeadZombie(world);
            } else if (type == 3) {
                zombie = new EntityBucketHeadZombie(world);
            } else if (type == 4) {
                zombie = new EntityFlagZombie(world);
            }
            if (zombie == null) continue;
            zombie.func_70107_b(block.func_177958_n(), block.func_177956_o(), block.func_177952_p());
            world.func_72838_d((Entity)zombie);
        }
    }

    private static BlockPos getBlock(World world, double x, double y, double z) {
        Block block;
        int nowY;
        int nowZ;
        int nowX;
        int dz;
        int dx;
        Random rand = new Random();
        do {
            dx = (rand.nextInt(20) + 0) * (rand.nextInt(1) == 1 ? 1 : -1);
            dz = (rand.nextInt(20) + 0) * (rand.nextInt(1) == 1 ? 1 : -1);
            nowX = MathHelper.func_76128_c((double)x) + dx;
            nowZ = MathHelper.func_76128_c((double)z) + dz;
            nowY = world.func_72800_K();
        } while (Math.abs(dx) + Math.abs(dz) > 80);
        while (nowY-- >= 0 && (block = world.func_180495_p(new BlockPos(nowX, nowY, nowZ)).func_177230_c()) == Blocks.field_150350_a) {
        }
        return new BlockPos(nowX, nowY + 1, nowZ);
    }

    public static int getAttackChance(long time) {
        return ConfigurationUtil.MainConfig.eventSettings.invadeChance;
    }

    public static int getSafeDayLength() {
        return ConfigurationUtil.MainConfig.eventSettings.safeDayLength;
    }
}

