/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.event;

import com.hungteen.pvzmod.capability.data.PlayerDataManager;
import com.hungteen.pvzmod.client.gui.mainwindow.PVZGuiTabPlayerData;
import com.hungteen.pvzmod.entities.plants.base.EntityPlantBase;
import com.hungteen.pvzmod.items.tools.ItemDaveShovel;
import com.hungteen.pvzmod.items.tools.ItemSummonCard;
import com.hungteen.pvzmod.packet.PacketHandler;
import com.hungteen.pvzmod.packet.PacketPlantLvlData;
import com.hungteen.pvzmod.packet.PacketPlayerData;
import com.hungteen.pvzmod.util.PlantsUtil;
import com.hungteen.pvzmod.util.PlayerUtil;
import com.hungteen.pvzmod.util.enums.Plants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerEvents {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (ev.player instanceof EntityPlayerMP && !ev.player.field_70170_p.field_72995_K) {
            PlayerDataManager plData = PlayerUtil.getPVZPlayer(ev.player);
            PlayerDataManager.PlayerStats playerStats = plData.getPlayerStats();
            PlayerDataManager.PlantStats plantStats = plData.getPlantStats();
            for (Plants plant : Plants.values()) {
                PacketHandler.CHANNEL.sendTo((IMessage)new PacketPlantLvlData(plant, plantStats.getPlantLevel(plant), plantStats.getPlantXp(plant), plantStats.getIsPlantLocked(plant)), (EntityPlayerMP)ev.player);
            }
            PacketHandler.CHANNEL.sendTo((IMessage)new PacketPlayerData(playerStats.getPlayerLevel(), playerStats.getPlayerXp(), playerStats.getPlayerSunNum(), playerStats.getPlayerEnergyNum(), playerStats.getPlayerMoney()), (EntityPlayerMP)ev.player);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone ev) {
        if (!ev.getEntityPlayer().field_70170_p.field_72995_K) {
            PlayerUtil.clonePlayerData(ev.getOriginal(), ev.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.EntityInteract ev) {
        World world = ev.getWorld();
        EntityPlayer player = ev.getEntityPlayer();
        Entity entity = ev.getTarget();
        Item item = player.func_184614_ca().func_77973_b();
        if (!world.field_72995_K && item instanceof ItemSummonCard && entity instanceof EntityPlantBase) {
            Plants plant = ((ItemSummonCard)item).getPlant();
            if (!player.func_184811_cZ().func_185141_a(item)) {
                EntityPlantBase newplant = PlantsUtil.getEntityForUpgrade(world, entity, plant);
                if (newplant == null) {
                    return;
                }
                newplant.setPlantLvl(PVZGuiTabPlayerData.getPlayerPlantCardLvl(plant));
                newplant.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                newplant.setOwnerName(player.func_70005_c_());
                int cost = newplant.getSunCost();
                int cooldownTime = newplant.getCoolDownTime();
                if (PlayerUtil.getPlayerSunNum(player) >= cost) {
                    PlayerUtil.addPlayerSunNum(player, -cost);
                    entity.func_70106_y();
                    world.func_72838_d((Entity)newplant);
                    player.func_184811_cZ().func_185145_a(item, cooldownTime);
                    newplant.func_184185_a(SoundEvents.field_187577_bU, 1.0f, 1.0f);
                    player.func_71029_a(StatList.func_188057_b((Item)item));
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        if (entity instanceof EntityPlantBase) {
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            Item item = stack.func_77973_b();
            if (item == Items.field_151048_u && ((EntityPlantBase)entity).canStartSuperMode()) {
                ((EntityPlantBase)entity).startSuperMode();
            }
            if (item instanceof ItemSpade) {
                if (!(item instanceof ItemDaveShovel)) {
                    stack.func_77972_a(5, (EntityLivingBase)player);
                }
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187571_bR, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                entity.func_70106_y();
            }
        }
    }

    private void dropItem(World world, ItemStack stack, double x, double y, double z) {
        EntityItem entityitem = new EntityItem(world, x, y, z, stack);
        entityitem.func_174869_p();
        world.func_72838_d((Entity)entityitem);
    }
}

