/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.gui.container;

import com.hungteen.pvzmod.registry.BlockRegister;
import com.hungteen.pvzmod.util.CraftUtil;
import com.hungteen.pvzmod.util.PlantsUtil;
import com.hungteen.pvzmod.util.enums.Plants;
import com.hungteen.pvzmod.util.enums.Ranks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ContainerCardTable
extends Container {
    private IInventory craftSlots;
    private IInventory inputSlots;
    private IInventory outputSlot;
    private BlockPos pos;
    private World world;
    private EntityPlayer player;
    private Plants resultPlant;
    private int prop;
    private int bonusProp;
    private boolean canShrink;

    public ContainerCardTable(World world, InventoryPlayer player, BlockPos pos) {
        int j;
        int i;
        this.world = world;
        this.pos = pos;
        this.player = player.field_70458_d;
        this.resultPlant = null;
        this.prop = 0;
        this.bonusProp = 0;
        this.canShrink = true;
        this.craftSlots = new InventoryCrafting((Container)this, 3, 3);
        this.inputSlots = new InventoryBasic("input", true, 2){

            public void func_70296_d() {
                super.func_70296_d();
                ContainerCardTable.this.func_75130_a((IInventory)this);
            }
        };
        this.outputSlot = new InventoryCraftResult();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot(this.craftSlots, i * 3 + j, 31 + 26 * i, 54 + 26 * j));
            }
        }
        this.func_75146_a(new Slot(this.inputSlots, 0, 146, 17){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150368_y);
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.inputSlots, 1, 146, 143){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == Items.field_190929_cY;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.outputSlot, 0, 146, 80){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }
        });
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player, j + i * 9 + 9, 48 + 18 * j, 174 + 18 * i));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player, i, 48 + 18 * i, 232));
        }
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        if (inventory == this.craftSlots) {
            this.checkPlant();
            if (this.resultPlant != null) {
                Ranks rank = PlantsUtil.getPlantRank(this.resultPlant);
                if (rank == null) {
                    System.out.println("error plant rank!");
                    return;
                }
                this.prop = 80 - 10 * rank.ordinal();
            } else {
                this.prop = 0;
            }
        } else if (inventory == this.inputSlots) {
            this.checkInput();
        }
    }

    private void checkPlant() {
        ItemStack midStack = this.craftSlots.func_70301_a(4);
        Plants[] plants = CraftUtil.getMatchPlantByMidItem(midStack.func_77973_b());
        if (plants == null) {
            return;
        }
        boolean hasResult = false;
        for (Plants plant : plants) {
            boolean canMatch = true;
            ItemStack[] itemstacks = CraftUtil.getCardRecipesByPlant(plant);
            if (itemstacks == null || itemstacks.length != 9) {
                System.out.println("recipes get error!");
                continue;
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.craftSlots.func_70301_a(i);
                System.out.println(i);
                if (stack.func_77969_a(itemstacks[i])) continue;
                canMatch = false;
                break;
            }
            if (!canMatch) continue;
            this.resultPlant = plant;
            hasResult = true;
            break;
        }
        if (!hasResult) {
            this.resultPlant = null;
        }
    }

    private void checkInput() {
        ItemStack luckStack = this.inputSlots.func_70301_a(0);
        ItemStack protectStack = this.inputSlots.func_70301_a(1);
        this.bonusProp = luckStack.func_190926_b() ? 0 : 20;
        this.canShrink = protectStack.func_190926_b();
    }

    public void onButtonClicked() {
        Random rand = new Random();
        if (this.resultPlant == null) {
            System.out.println("error plant!");
            return;
        }
        if (rand.nextInt(100) < this.getCraftProp()) {
            ItemStack result = new ItemStack(PlantsUtil.getItemFromPlant(this.resultPlant), 1);
            this.outputSlot.func_70299_a(0, result);
            this.clearCraftMatrix();
        } else if (this.canShrink) {
            this.clearCraftMatrix();
        }
        if (!this.inputSlots.func_70301_a(0).func_190926_b()) {
            this.inputSlots.func_70301_a(0).func_190918_g(1);
        }
        if (!this.inputSlots.func_70301_a(1).func_190926_b()) {
            this.inputSlots.func_70301_a(1).func_190918_g(1);
        }
        this.inputSlots.func_70296_d();
    }

    private void clearCraftMatrix() {
        for (int i = 0; i < 9; ++i) {
            this.craftSlots.func_70301_a(i).func_190918_g(1);
        }
        this.craftSlots.func_70296_d();
    }

    public boolean getCanButtonPress() {
        return this.resultPlant != null && this.outputSlot.func_70301_a(0).func_190926_b();
    }

    public int getCraftProp() {
        return this.prop + this.bonusProp;
    }

    public Plants getCraftPlant() {
        return this.resultPlant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack newStack = slot.func_75211_c();
        ItemStack oldStack = newStack.func_77946_l();
        boolean isMerged = false;
        if (index >= 0 && index <= 11) {
            if (!this.func_75135_a(newStack, 12, 48, true)) {
                return ItemStack.field_190927_a;
            }
        } else if (index >= 12 && index <= 38) {
            if (!this.func_75135_a(newStack, 39, 48, false)) return ItemStack.field_190927_a;
            isMerged = true;
        } else if (index >= 39 && index <= 47) {
            if (!this.func_75135_a(newStack, 12, 39, false)) return ItemStack.field_190927_a;
            isMerged = true;
        }
        if (!isMerged) {
            return ItemStack.field_190927_a;
        }
        if (newStack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
            return oldStack;
        } else {
            slot.func_75218_e();
        }
        return oldStack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.world.field_72995_K) {
            this.func_193327_a(playerIn, this.world, this.inputSlots);
            this.func_193327_a(playerIn, this.world, this.craftSlots);
            this.func_193327_a(playerIn, this.world, this.outputSlot);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.world.func_180495_p(this.pos).func_177230_c() != BlockRegister.CARD_TABLE) {
            return false;
        }
        return playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }
}

