/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.gui.guicontainer.plantcards;

import com.hungteen.pvzmod.client.gui.mainwindow.PVZGuiTabPlayerData;
import com.hungteen.pvzmod.registry.ItemRegister;
import com.hungteen.pvzmod.util.PlantsUtil;
import com.hungteen.pvzmod.util.RenderUtil;
import com.hungteen.pvzmod.util.enums.Plants;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class GuiPlantBase
extends GuiContainer {
    protected Plants plantType;
    protected int plantCardX = 18;
    protected int plantCardY = 20;
    protected int nameWidth = 132;
    protected int nameHeight = 32;
    protected int dataCnt;
    protected int dataIconX = 20;
    protected int dataIconY = 116;
    protected int dataIconYdelta = 23;
    protected final int dataMaxCnt = 10;
    protected String[] dataInfo = new String[6];
    protected String[] dataOutput = new String[6];
    protected String[] plantInfo = new String[6];
    protected int barOffsetX = 17;
    protected int barOffsetY = 5;
    protected int barLength = 50;
    protected int barWidth = 8;
    protected int textLength = 164;
    protected int textWidth = 64;
    protected int textOffsetX = 19;
    protected int textOffsetY = 52;
    protected int maxLvl;
    protected int lvl;
    protected int xp;
    private static final ResourceLocation TEXTURE = new ResourceLocation("pvz:textures/gui/container/plant_book.png");

    public GuiPlantBase(Container inventorySlotsIn, Plants plant) {
        super(inventorySlotsIn);
        this.plantType = plant;
        this.field_146999_f = 200;
        this.field_147000_g = 256;
        this.dataCnt = 0;
        this.lvl = PVZGuiTabPlayerData.getPlayerPlantCardLvl(this.plantType);
        this.xp = PVZGuiTabPlayerData.getPlayerPlantCardXp(this.plantType);
        this.maxLvl = PlantsUtil.getPlantMaxLvl(this.plantType);
        this.dataInfo[1] = new TextComponentTranslation("text.plantLvl.name", new Object[0]).func_150254_d();
        this.dataInfo[2] = new TextComponentTranslation("text.plantXp.name", new Object[0]).func_150254_d();
        this.dataInfo[3] = new TextComponentTranslation("text.plantCost.name", new Object[0]).func_150254_d();
        this.dataInfo[4] = new TextComponentTranslation("text.plantCD.name", new Object[0]).func_150254_d();
        this.dataInfo[5] = new TextComponentTranslation("text.plantHP.name", new Object[0]).func_150254_d();
        for (int i = 0; i < 6; ++i) {
            this.plantInfo[i] = "";
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int offsetX = (this.field_146294_l - this.field_146999_f) / 2;
        int offsetY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawPlantCard();
        this.dataCnt = 0;
        this.drawDataPlantLvl();
        this.drawDataPlantXp();
        this.drawDataPlantSunCost();
        this.drawDataPlantCD();
        this.drawDataPlantHealth();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawPlantName();
        this.drawBarInfo();
        this.drawPlantInfo();
    }

    protected void drawPlantInfo() {
        int x = this.textLength / 2 + this.textOffsetX;
        int y = this.textOffsetY;
        for (int i = 0; i < 6; ++i) {
            if (this.plantInfo[i].isEmpty()) continue;
            RenderUtil.drawCenteredScaledString(this.field_146297_k.field_71466_p, this.plantInfo[i], x, y + 10 * i, 1.0f, 0, RenderUtil.StringRenderType.NORMAL);
        }
    }

    protected void drawBarInfo() {
        for (int i = 1; i <= 5; ++i) {
            int x = this.barOffsetX + this.dataIconX + this.barLength / 2;
            int y = this.barOffsetY + this.dataIconY + (i - 1) * this.dataIconYdelta + 1;
            RenderUtil.drawCenteredScaledString(this.field_146297_k.field_71466_p, this.dataOutput[i], x, y, 0.8f, 0, RenderUtil.StringRenderType.NORMAL);
        }
    }

    protected void drawDataPlantLvl() {
        ++this.dataCnt;
        this.drawDataBar(new ItemStack(Items.field_151062_by), this.lvl, this.maxLvl);
        this.dataOutput[this.dataCnt] = this.dataInfo[this.dataCnt] + ":" + this.lvl;
    }

    protected void drawDataPlantXp() {
        ++this.dataCnt;
        this.drawDataBar(new ItemStack(Items.field_151062_by), this.xp, PlantsUtil.getPlantLvlUpXp(this.lvl));
        this.dataOutput[this.dataCnt] = this.dataInfo[this.dataCnt] + ":" + this.xp;
    }

    protected void drawDataPlantSunCost() {
        ++this.dataCnt;
        this.drawDataBar(new ItemStack(ItemRegister.LIGHT_ELEMENT), 1.0, 1.0);
        this.dataOutput[this.dataCnt] = this.dataInfo[this.dataCnt] + ":" + PlantsUtil.getPlantSunCost(this.plantType);
    }

    protected void drawDataPlantHealth() {
        ++this.dataCnt;
        this.drawDataBar(new ItemStack(Items.field_151034_e), PlantsUtil.getPlantMaxHealth(this.plantType, this.lvl), PlantsUtil.getPlantMaxHealth(this.plantType, this.maxLvl));
        this.dataOutput[this.dataCnt] = this.dataInfo[this.dataCnt] + ":" + PlantsUtil.getPlantMaxHealth(this.plantType, this.lvl);
    }

    protected void drawDataPlantCD() {
        ++this.dataCnt;
        int a = PlantsUtil.getPlantCoolDownTime(this.plantType, this.lvl) - PlantsUtil.getPlantCoolDownTime(this.plantType, this.maxLvl);
        int b = PlantsUtil.getPlantCoolDownTime(this.plantType, 1) - PlantsUtil.getPlantCoolDownTime(this.plantType, this.maxLvl);
        this.drawDataBar(new ItemStack(Items.field_151113_aN), a, b);
        this.dataOutput[this.dataCnt] = this.dataInfo[this.dataCnt] + ":" + (float)PlantsUtil.getPlantCoolDownTime(this.plantType, this.lvl) * 1.0f / 20.0f + "s";
    }

    protected void drawDataBar(ItemStack item, double a, double b) {
        this.field_146296_j.func_180450_b(item, this.field_147003_i + this.dataIconX, this.field_147009_r + this.dataIconY + (this.dataCnt - 1) * this.dataIconYdelta);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int x = this.dataIconX + this.barOffsetX;
        int y = this.dataIconY + this.barOffsetY + (this.dataCnt - 1) * this.dataIconYdelta;
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 206, 0, this.barLength, this.barWidth);
        int len = MathHelper.func_76128_c((double)((double)this.barLength * a / b));
        if (a != 0.0 && len == 0) {
            len = 1;
        }
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 206, 8, len, this.barWidth);
    }

    protected void drawPlantCard() {
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        this.field_146296_j.func_180450_b(new ItemStack(PlantsUtil.getItemFromPlant(this.plantType)), (this.field_147003_i + this.plantCardX) / 2, (this.field_147009_r + this.plantCardY) / 2);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
    }

    protected void drawPlantName() {
        int x = this.plantCardX + this.nameHeight + this.nameWidth / 2;
        int y = this.plantCardY + this.nameHeight / 4;
        String name = PlantsUtil.getPlantName(this.plantType);
        int color = this.getNameColor();
        RenderUtil.drawCenteredScaledString(this.field_146297_k.field_71466_p, name, x, y, 1.5f, color, RenderUtil.StringRenderType.NORMAL);
    }

    protected int getNameColor() {
        int lvl = PVZGuiTabPlayerData.getPlayerPlantCardLvl(this.plantType);
        if (lvl <= 6) {
            return 9593401;
        }
        if (lvl <= 13) {
            return 0xE3E8E8;
        }
        if (lvl <= 20) {
            return 0xFFDF00;
        }
        return 9593401;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

