/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.items.weapons;

import com.hungteen.pvzmod.Main;
import com.hungteen.pvzmod.entities.bullets.EntityPea;
import com.hungteen.pvzmod.items.ItemBase;
import com.hungteen.pvzmod.registry.CreativeTabRegister;
import com.hungteen.pvzmod.registry.ItemRegister;
import com.hungteen.pvzmod.util.ItemUtil;
import com.hungteen.pvzmod.util.PlayerUtil;
import com.hungteen.pvzmod.util.enums.Plants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemPeaGun
extends ItemBase {
    private IInventory backpack = new InventoryBasic("back_pack", true, 28);
    private final float normalShootSpeed = 2.2f;

    public ItemPeaGun(String name) {
        super(name, CreativeTabRegister.TOOL_TAB);
        this.func_77625_d(1);
        this.func_77664_n();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        BlockPos pos = new BlockPos((Entity)playerIn);
        if (handIn == EnumHand.MAIN_HAND) {
            if (!worldIn.field_72995_K) {
                this.startAttack(worldIn, playerIn, stack);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        } else if (handIn == EnumHand.OFF_HAND && !worldIn.field_72995_K && playerIn.func_70093_af()) {
            playerIn.openGui((Object)Main.instance, 39, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private void startAttack(World world, EntityPlayer player, ItemStack stack) {
        ItemUtil.restoreFromItemStack(stack, this.backpack);
        ItemStack spStack = this.backpack.func_70301_a(0);
        for (int i = 1; i < 28; ++i) {
            ItemStack newStack = this.backpack.func_70301_a(i);
            if (!this.canPlayerUseItemPea(player, newStack.func_77973_b())) continue;
            if (field_77697_d.nextInt(2) == 0) {
                this.specialShoot(world, player, newStack.func_77973_b(), spStack.func_77973_b());
            } else {
                this.shoot(world, player, newStack.func_77973_b(), 2.2f, ShootType.NORMAL);
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187805_fE, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            newStack.func_190918_g(1);
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.getCoolDownTime(player));
            break;
        }
        ItemUtil.convertToItemStack(stack, this.backpack);
    }

    private int getCoolDownTime(EntityPlayer player) {
        if (PlayerUtil.getPlantLvl(player, Plants.GATLING_PEA) >= 5) {
            return 7;
        }
        if (PlayerUtil.getPlantLvl(player, Plants.THREE_PEATER) >= 5) {
            return 10;
        }
        if (PlayerUtil.getPlantLvl(player, Plants.DOUBLE_SHOOTER) >= 5) {
            return 15;
        }
        if (PlayerUtil.getPlantLvl(player, Plants.SPLIT_PEA) >= 5) {
            return 20;
        }
        return 30;
    }

    private void shoot(World world, EntityPlayer player, Item item, double speed, ShootType type) {
        EntityPea pea = new EntityPea(world, (EntityLivingBase)player, EntityPea.Type.NORMAL, this.getPeaState(item));
        pea.func_70107_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d vec = player.func_70040_Z().func_186678_a(speed);
        if (type == ShootType.BACK) {
            vec = vec.func_186678_a(-1.0);
        } else if (type == ShootType.LEFT_FRONT) {
            pea.func_70107_b(player.field_70165_t - vec.field_72449_c * (double)Item.field_77697_d.nextFloat(), player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v + vec.field_72450_a * (double)Item.field_77697_d.nextFloat());
        } else if (type == ShootType.RIGHT_FRONT) {
            pea.func_70107_b(player.field_70165_t + vec.field_72449_c * (double)Item.field_77697_d.nextFloat(), player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v - vec.field_72450_a * (double)Item.field_77697_d.nextFloat());
        } else if (type == ShootType.UNSTABLE) {
            vec = vec.func_72441_c((double)(Item.field_77697_d.nextFloat() - 0.5f), (double)(Item.field_77697_d.nextFloat() - 0.5f), (double)(Item.field_77697_d.nextFloat() - 0.5f));
        }
        pea.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        world.func_72838_d((Entity)pea);
    }

    private void specialShoot(World world, EntityPlayer player, Item item, Item spItem) {
        if (spItem == ItemRegister.PEA_SHOOTER_CARD) {
            this.peaShooterShoot(world, player, item);
        } else if (spItem == ItemRegister.SPLIT_PEA_CARD) {
            this.splitPeaShoot(world, player, item);
        } else if (spItem == ItemRegister.DOUBLE_SHOOTER_CARD) {
            this.doubleShooterShoot(world, player, item);
        } else if (spItem == ItemRegister.THREE_PEATER_CARD) {
            this.threePeaterShoot(world, player, item);
        } else if (spItem == ItemRegister.GATLING_PEA_CARD) {
            this.gatlingPeaShoot(world, player, item);
        } else {
            this.shoot(world, player, item, 2.2f, ShootType.NORMAL);
        }
    }

    private void peaShooterShoot(World world, EntityPlayer player, Item item) {
        int cnt = 4;
        for (int i = 0; i < cnt; ++i) {
            this.shoot(world, player, item, 2.2f - 0.1f * (float)i, ShootType.NORMAL);
        }
    }

    private void splitPeaShoot(World world, EntityPlayer player, Item item) {
        int i;
        int cnt = 4;
        for (i = 0; i < cnt; ++i) {
            this.shoot(world, player, item, 2.2f - 0.1f * (float)i, ShootType.NORMAL);
        }
        for (i = 0; i < 2 * cnt; ++i) {
            this.shoot(world, player, item, 2.2f - 0.05f * (float)i, ShootType.BACK);
        }
    }

    private void doubleShooterShoot(World world, EntityPlayer player, Item item) {
        int cnt = 8;
        for (int i = 0; i < cnt; ++i) {
            this.shoot(world, player, item, 2.2f - 0.05f * (float)i, ShootType.NORMAL);
        }
    }

    private void threePeaterShoot(World world, EntityPlayer player, Item item) {
        int cnt = 4;
        for (int i = 0; i < cnt; ++i) {
            this.shoot(world, player, item, 2.2f - 0.1f * (float)i, ShootType.NORMAL);
            this.shoot(world, player, item, 2.2f - 0.1f * (float)i, ShootType.LEFT_FRONT);
            this.shoot(world, player, item, 2.2f - 0.1f * (float)i, ShootType.RIGHT_FRONT);
        }
    }

    private void gatlingPeaShoot(World world, EntityPlayer player, Item item) {
        int cnt = 16;
        for (int i = 0; i < cnt; ++i) {
            this.shoot(world, player, item, 2.2f - 0.02f * (float)i, ShootType.UNSTABLE);
        }
    }

    private EntityPea.State getPeaState(Item item) {
        if (item == ItemRegister.PEA) {
            return EntityPea.State.NORMAL;
        }
        if (item == ItemRegister.SNOW_PEA) {
            return EntityPea.State.SNOW;
        }
        return EntityPea.State.NORMAL;
    }

    private boolean canPlayerUseItemPea(EntityPlayer player, Item item) {
        if (item == ItemRegister.PEA) {
            return PlayerUtil.getPlantLvl(player, Plants.PEA_SHOOTER) >= 5;
        }
        if (item == ItemRegister.SNOW_PEA) {
            return PlayerUtil.getPlantLvl(player, Plants.SNOW_PEA) >= 5;
        }
        return false;
    }

    public static enum ShootType {
        NORMAL,
        BACK,
        LEFT_FRONT,
        RIGHT_FRONT,
        UNSTABLE;

    }
}

