/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.packet;

import com.hungteen.pvzmod.client.gui.mainwindow.PVZGuiTabPlayerData;
import com.hungteen.pvzmod.util.enums.Plants;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPlantLvlData
implements IMessage {
    private int plantId;
    private int level;
    private int xp;
    private boolean islocked;

    public PacketPlantLvlData() {
    }

    public PacketPlantLvlData(Plants plant, int lvl, int xp, boolean is) {
        this.plantId = plant.ordinal();
        this.level = lvl;
        this.xp = xp;
        this.islocked = is;
    }

    public void fromBytes(ByteBuf buffer) {
        this.plantId = buffer.readInt();
        this.level = buffer.readInt();
        this.xp = buffer.readInt();
        this.islocked = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.plantId);
        buffer.writeInt(this.level);
        buffer.writeInt(this.xp);
        buffer.writeBoolean(this.islocked);
    }

    public static class Handler
    implements IMessageHandler<PacketPlantLvlData, IMessage> {
        public IMessage onMessage(PacketPlantLvlData msg, MessageContext ctx) {
            Plants plant = Plants.values()[msg.plantId];
            if (plant != null) {
                PVZGuiTabPlayerData.setPlayerPlantData(plant, msg.level, msg.xp, msg.islocked);
            } else {
                System.out.println("Error trying to set plant data in client plants holder, skipping");
            }
            return null;
        }
    }
}

