/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.registry;

import com.hungteen.pvzmod.capability.CapabilityHandler;
import com.hungteen.pvzmod.capability.handler.PVZPlayerCapability;
import com.hungteen.pvzmod.capability.interfaces.ICapabilityPVZPlayer;
import com.hungteen.pvzmod.capability.storage.PVZPlayerStorage;
import com.hungteen.pvzmod.command.PVZCommandPlantLvl;
import com.hungteen.pvzmod.event.BlockEvents;
import com.hungteen.pvzmod.event.ConfigurationEvents;
import com.hungteen.pvzmod.event.EntityEvents;
import com.hungteen.pvzmod.event.PlayerEvents;
import com.hungteen.pvzmod.event.TreeEvents;
import com.hungteen.pvzmod.event.WorldEvents;
import com.hungteen.pvzmod.gui.GuiHandler;
import com.hungteen.pvzmod.packet.PacketHandler;
import com.hungteen.pvzmod.registry.BlockRegister;
import com.hungteen.pvzmod.registry.CreativeTabRegister;
import com.hungteen.pvzmod.registry.EntityRegister;
import com.hungteen.pvzmod.registry.EntitySpawnRegister;
import com.hungteen.pvzmod.registry.ItemRegister;
import com.hungteen.pvzmod.registry.PotionRegister;
import com.hungteen.pvzmod.registry.RecipeRegister;
import com.hungteen.pvzmod.util.interfaces.IHasModel;
import com.hungteen.pvzmod.world.gen.WorldGenOres;
import com.hungteen.pvzmod.world.gen.WorldGenOrigins;
import com.hungteen.pvzmod.world.gen.WorldGenStructures;
import com.hungteen.pvzmod.world.gen.WorldGenTrees;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ItemRegister.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BlockRegister.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ItemRegister.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : BlockRegister.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void preInitRegistries() {
        EntityRegister.registerEntities();
        EntitySpawnRegister.registerEntitySpawn();
        new CreativeTabRegister();
        RegistryHandler.registerCapabilities();
        RegistryHandler.registerGenerators();
        PotionRegister.registerPotions();
    }

    public static void initRegistries() {
        new GuiHandler();
        RegistryHandler.registerEvents();
        PacketHandler.init();
        RecipeRegister.init();
    }

    public static void postInitRegistries() {
    }

    public static void serverRegistries(FMLServerStartingEvent ev) {
        ev.registerServerCommand((ICommand)new PVZCommandPlantLvl());
    }

    private static void registerGenerators() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOres(), (int)3);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenTrees(), (int)15);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOrigins(), (int)30);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenStructures(), (int)0);
    }

    private static void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        MinecraftForge.EVENT_BUS.register((Object)new WorldEvents());
        MinecraftForge.EVENT_BUS.register((Object)new EntityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationEvents());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new TreeEvents());
    }

    private static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(ICapabilityPVZPlayer.class, (Capability.IStorage)new PVZPlayerStorage(), PVZPlayerCapability.class);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityHandler());
    }
}

